<?php
namespace boru\boruelastic\query;

class TermsQuery extends BaseQuery {

    public function __construct($field,$values,$boost=null) {
        $this->terms($field,$values);
        if(!is_null($boost)) {
            $this->boost($boost);
        }
    }

    public function terms($field,$values) {
        $template = [
            "terms" => [
                $field => $values
            ]
        ];
        $this->set($template);
        return $this;
    }

    public function boost($value) {
        $this->set("terms.boost",$value);
        return $this;
    }
}