<?php
namespace boru\boruelastic\result;

use boru\boruelastic\type\ArrayIterator;

class Aggregation extends ArrayIterator {

    private $name;
    private $buckets;

    public function __construct($name,$data) {
        $this->name = $name;
        $this->setIteratorArray($data["buckets"]);
        unset($data["buckets"]);
        $this->set($data);
    }

    public function name() {
        return $this->name;
    }
    public function docCountErrorUpperBound() {
        return $this->get("doc_count_error_upper_bound");
    }
    public function sumOtherDocCount() {
        return $this->get("sum_other_doc_count");
    }
    /**
     * Retrieve all buckets
     * @return Bucket[] 
     */
    public function buckets() {
        if(is_null($this->buckets)) {
            $buckets = $this->getAll();
            array_walk($buckets,function(&$bucket) {
                $bucket = new Bucket($bucket);
                $this->buckets[$bucket->key()] = $bucket;
            });
        }
        return $this->buckets;
    }
    /**
     * Retrieve a bucket by key or index#
     * @param mixed $keyOrInt 
     * @return Bucket|false 
     */
    public function bucket($keyOrInt) {
        if(is_numeric($keyOrInt)) {
            return $this->getAt("buckets",$keyOrInt);
        } else {
            $this->buckets();
            if(isset($this->buckets[$keyOrInt])) {
                return $this->buckets[$keyOrInt];
            }
            return false;
        }
    }

    public function transformIteratorValue($value) {
        return new Bucket($value);
    }

    public function toArray() {
        $data = parent::toArray();
        $data["buckets"] = $this->getAll();
        return $data;
    }
}