<?php
namespace boru\boruelastic;

use boru\boruelastic\agg\AvgAgg;
use boru\boruelastic\agg\BaseAgg;
use boru\boruelastic\agg\FilterAgg;
use boru\boruelastic\agg\TermsAgg;
use boru\boruelastic\agg\TopHitsAgg;


class Aggs extends BaseAgg {
    private $aggs;
    public function __construct() {
    }

    public function toArray() {
        $data = [];
        foreach($this->aggs as $name=>$part) {
            if(!$part->isEmpty()) {
                $data[$name] = $part;
            }
        }
        return $data;
    }

    public function add($name,$agg) {
        $this->aggs[$name] = $agg;
    }

    public static function avg($field) {
        return new AvgAgg($field);
    }
    public static function terms($field,$size=1) {
        return new TermsAgg($field,$size);
    }
    public static function filter($filter,$aggs=null) {
        return new FilterAgg($filter,$aggs);
    }
    public static function topHits($size=1,$source=null,$sort=null) {
        return new TopHitsAgg($size,$source,$sort);
    }
    public static function instance() {
        return new static();
    }
}