<?php
namespace boru\boruelastic;

use boru\boruelastic\conn\Connector;

class ElasticClient extends Connector {
    public function indexExists($index) {
        try {
            $response = $this->getRequest($index,[],false);
        } catch (\Exception $e) {
            if($e->getCode() == 404) return false;
            throw $e;
        }
        if(is_array($response)) {
            if(isset($response["error"])) {
                if($response["error"]["type"] == "index_not_found_exception") return false;
            }
        }
        return true;
    }
    public function templateExists($templateName) {
        $path = "_template/".$templateName;
        try {
            $response = $this->headRequest($path,[],false);
        } catch (\Exception $e) {
            if($e->getCode() == 404) return false;
            throw $e;
        }
        return true;
    }

    public function createIndex($index,$settings=[]) {
        $path = $index;
        return $this->putRequest($path,$settings);
    }
    public function createTemplate($templateName,$settings) {
        $path = "_template/".$templateName;
        $body = json_encode($settings,JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES);
        return $this->putRequest($path,$body);
    }

    /**
     * @param Search $search 
     * @param string|null $index 
     * @return \React\Promise\PromiseInterface|\boru\boruelastic\result\Results 
     * @throws Exception 
     */
    public function search($search, $index=null) {
        if(!($search instanceof Search)) throw new \Exception("search() expects a Search object");
        $search->client($this);
        return $search->run($index);
    }

    /**
     * @param Record $record 
     * @return \React\Promise\PromiseInterface|\boru\boruelastic\result\Results 
     * @throws Exception 
     */
    public function index($record) {
        if(!($record instanceof Record)) throw new \Exception("index() expects a Record object");
        $record->client($this);
        return $record->save();
    }

    /**
     * @param Record $record 
     * @return \React\Promise\PromiseInterface|\boru\boruelastic\result\Results 
     * @throws Exception 
     */
    public function delete($record) {
        if(!($record instanceof Record)) throw new \Exception("delete() expects a Record object");
        $record->client($this);
        return $record->delete();
    }

    /**
     * @param string $index 
     * @param string $id 
     * @param bool|null $async 
     * @return \React\Promise\PromiseInterface|\boru\boruelastic\result\Results 
     * @throws Exception 
     */
    public function deleteById($index,$id,$async=null) {
        $path = $index."/_doc/".$id;
        return $this->deleteRequest($path,[],$async);
    }
}