<?php
namespace boru\boruelastic\agg;

use boru\boruelastic\type\BaseType;

class BaseAgg extends BaseType {
    private $aggs = [];
    public function isEmpty() {
        return empty($this->get());
    }

    public function getSubAggs() {
        return $this->aggs;
    }

    public function add($name,$agg) {
        $this->aggs[$name] = $agg;
        return $this;
    }

    public function agg($agg) {
        if(is_array($agg)) {
            return $this->aggs($agg);
        }
        $this->aggs[] = $agg;
        return $this;
    }
    public function aggs($aggs) {
        if(!is_array($aggs)) {
            return $this->agg($aggs);
        }
        $this->aggs = array_merge($this->aggs,$aggs);
        return $this;
    }

    public function toArray() {
        $template = $this->get();
        $subAggs = $this->getSubAggs();
        if(!empty($subAggs)) {
            $template["aggs"] = $subAggs;
        }
        return $template;
    }
}