<?php
namespace boru\boruelastic\query;

class MatchQuery extends BaseQuery {

    public function __construct($field,$values,$boost=null) {
        $this->match($field,$values);
        if(!is_null($boost)) {
            $this->boost($boost);
        }
    }

    public function match($field,$values) {
        $template = [
            "match" => [
                $field => $values
            ]
        ];
        $this->set($template);
        return $this;
    }

    public function boost($value) {
        $this->set("match.boost",$value);
        return $this;
    }
    public function operator($value) {
        $this->set("match.operator",$value);
        return $this;
    }
    public function analyzer($value) {
        $this->set("match.analyzer",$value);
        return $this;
    }
}