<?php
namespace boru\boruelastic\query;

class RangeQuery extends BaseQuery {
    private $field;

    public function __construct($field,$comparator=null,$value=null) {
        $this->setField($field);
        if(!is_null($comparator) && !is_null($value)) {
            $this->range($field,$comparator,$value);
        }
    }

    public function range($field,$comparator,$value) {
        $template = [
            "range" => [
                $field => [
                    $comparator => $value
                ]
            ]
        ];
        $this->set($template);
        return $this;
    }

    public function lte($value) {
        if(is_null($this->field)) {
            throw new \Exception("Field must be set before calling lte()");
        }
        return $this->range($this->field,"lte",$value);
    }
    public function lt($value) {
        if(is_null($this->field)) {
            throw new \Exception("Field must be set before calling lt()");
        }
        return $this->range($this->field,"lt",$value);
    }
    public function gte($value) {
        if(is_null($this->field)) {
            throw new \Exception("Field must be set before calling gte()");
        }
        return $this->range($this->field,"gte",$value);
    }
    public function gt($value) {
        if(is_null($this->field)) {
            throw new \Exception("Field must be set before calling gt()");
        }
        return $this->range($this->field,"gt",$value);
    }
    public function setField($field) {
        $this->field = $field;
        return $this;
    }
}