<?php
namespace boru\boruelastic\type;

class InnerHitsType extends BaseType {
    public function __construct($name=NULL,$sort=NULL,$fields=NULL,$size=NULL,$collapse=NULL,$source=NULL) {
        $template = [
            "inner_hits" => [
                "name" => null,
                "sort" => null,
                "collapse" => null,
                "fields" => null,
                "size" => null,
                "_source" => false,
            ]
        ];
        $this->set($template);
        if(!is_null($name)) {
            $this->name($name);
        }
        if(!is_null($fields)) {
            $this->fields($fields);
        }
        if(!is_null($size)) {
            $this->size($size);
        }
        if(!is_null($sort)) {
            $this->sort($sort);
        }
        if(!is_null($collapse)) {
            $this->collapse($collapse);
        }
        if(!is_null($source)) {
            $this->source($source);
        }
    }
    public function toArray() {
        $name = $this->get("inner_hits.name");
        $sort = $this->get("inner_hits.sort");
        $collapse = $this->get("inner_hits.collapse");
        $fields = $this->get("inner_hits.fields");
        $size = $this->get("inner_hits.size");
        $source = $this->get("inner_hits._source");
        $data = [];
        if(!is_null($name)) {
            $data["name"] = $name;
        }
        if(!is_null($sort)) {
            $data["sort"] = $sort;
        }
        if(!is_null($collapse)) {
            $data["collapse"] = $collapse;
        }
        if(!is_null($fields)) {
            $data["fields"] = $fields;
        }
        if(!is_null($size)) {
            $data["size"] = $size;
        }
        if(!is_null($source)) {
            $data["_source"] = $source;
        }
        return $data;
    }

    public function name($name) {
        $this->set("inner_hits.name",$name);
        return $this;
    }
    public function sort($sort) {
        $this->set("inner_hits.sort",$sort);
        return $this;
    }
    public function collapse($collapse) {
        $this->set("inner_hits.collapse",$collapse);
        return $this;
    }
    public function fields($fields) {
        $this->set("inner_hits.fields",$fields);
        return $this;
    }
    public function size($size) {
        $this->set("inner_hits.size",$size);
        return $this;
    }
    public function source($source) {
        $this->set("inner_hits._source",$source);
        return $this;
    }

    public static function instance($name=NULL,$sort=NULL,$fields=NULL,$size=NULL,$collapse=NULL,$source=NULL) {
        return new static($name,$sort,$fields,$size,$collapse,$source);
    }
}