#!/usr/bin/env php
<?php
use boru\borumcp\Client;
require __DIR__.'/init.php';

if (PHP_SAPI !== 'cli' && realpath($argv[0]) === __FILE__) {
    die("This script must be run from the command line.\n");
}
// --- CLI entry point ---

$token = $minter->mint(['sub'=>'responses-api','roles'=>['mcp']], 180);
echo "Using token:\n$token\n\n";
$client = new Client($host, $port);
$client->connect();
$client->initialize($token);

// Run listener in a background process
$pid = pcntl_fork();
if ($pid === 0) {
    // child process reads incoming messages
    $client->readLoop();
    exit(0);
}

// parent process allows interactive commands
echo "🧪 MCP TCP Test Client\n";
echo "Type 'list' to list tools, 'call <tool> {json}' to call a tool, 'exit' to quit\n\n";

while (true) {
    $line = trim(fgets(STDIN));
    if ($line === 'exit') {
        $client->close();
        posix_kill($pid, SIGTERM);
        exit(0);
    } elseif ($line === 'list') {
        $client->listTools();
    } elseif (strpos($line, 'call ') === 0) {
        // e.g. call echo_text {"text":"hello"}
        $parts = explode(' ', $line, 3);
        $tool = isset($parts[1]) ? $parts[1] : null;
        $args = isset($parts[2]) ? json_decode($parts[2], true) : array();
        if ($tool) {
            $client->callTool($tool, $args ?: array());
        }
    }
}