<?php
namespace boru\borumcp\Authenticators;

use boru\borumcp\Interfaces\AuthenticatorInterface;

/**
 * Minimal example: compares to one shared secret.
 * In prod, swap this for a JWT verifier or your own callback.
 */
final class SharedSecretAuthenticator implements AuthenticatorInterface {
    private $secret;
    private $principal;
    public function __construct($secret, array $principal = array('sub'=>'mcp-client','roles'=>array('default'))) {
        $this->secret = (string)$secret;
        $this->principal = $principal;
    }
    public function verify($token) {
        if (!is_string($token) || $token === '') return null;
        if (hash_equals($this->secret, $token)) return $this->principal;
        return null;
    }

    public function getSigner() {
        return null; // Not supported for shared secret
    }
    public function getMinter() {
        return null; // Not supported for shared secret
    }
}