<?php
namespace boru\borumcp;

use boru\borumcp\Interfaces\AuthenticatorInterface;
use boru\borumcp\Core\JwtMinter;
/**
 * Minimal MCP TCP client for testing
 * PHP 5.6/7 compatible
 */

class Client
{
    private $host;
    private $port;
    private $socket;

    /** @var Server */
    private $server;

    /** @var AuthenticatorInterface|null */
    private $authenticator = null;

    /** @var JwtMinter|null */
    private $minter = null;

    public function __construct($host = '127.0.0.1', $port = 9000)
    {
        $this->host = $host;
        $this->port = (int)$port;
    }

    public function server($server=null)
    {
        if ($server instanceof Server) {
            $this->server = $server;
        }
        return $this->server;
    }

    public function setServer($server) {
        if ($server instanceof Server) {
            $this->server = $server;
            $this->host = $server->bindIp();
            $this->port = $server->bindPort();
            $this->authenticator = $server->authenticator();
            $this->minter = ($this->authenticator && method_exists($this->authenticator, 'getMinter')) ? $this->authenticator->getMinter() : null;
        }
    }

    public function connect()
    {
        $errno = 0;
        $errstr = '';
        $this->socket = @fsockopen($this->host, $this->port, $errno, $errstr, 3);
        if (!$this->socket) {
            throw new \RuntimeException("Failed to connect to {$this->host}:{$this->port} - $errstr ($errno)");
        }
        stream_set_blocking($this->socket, false);
        echo "✅ Connected to {$this->host}:{$this->port}\n";
    }

    public function send($json)
    {
        if (!$this->socket) {
            throw new \RuntimeException("Not connected");
        }
        $line = rtrim($json) . "\n";
        fwrite($this->socket, $line);
    }

    public function readLoop()
    {
        while (true) {
            $data = fgets($this->socket);
            if ($data !== false) {
                echo "📥 [Server] $data";
            }
            usleep(100000); // 100ms
        }
    }

    public function close()
    {
        if ($this->socket) {
            fclose($this->socket);
            echo "🔌 Disconnected\n";
        }
    }

    public function initialize($token = null)
    {
        if( $token === null && $this->minter instanceof JwtMinter ) {
            $token = $this->minter->mint();
        }
        $payload = array(
            'jsonrpc' => '2.0',
            'id' => 1,
            'method' => 'initialize',
            'params' => array(
                'protocolVersion' => '2025-06-18'
            )
        );
        if ($token !== null) {
            $payload['params']['authToken'] = $token;
        }
        $this->send(json_encode($payload));
    }

    public function listTools()
    {
        $payload = array(
            'jsonrpc' => '2.0',
            'id' => 2,
            'method' => 'tools/list',
            'params' => new \stdClass()
        );
        $this->send(json_encode($payload));
    }

    public function callTool($toolName, array $arguments = array())
    {
        $payload = array(
            'jsonrpc' => '2.0',
            'id' => 3,
            'method' => 'tools/call',
            'params' => array(
                'name' => $toolName,
                'arguments' => $arguments
            )
        );
        $this->send(json_encode($payload));
    }
}
