<?php
namespace boru\borumcp\Core;

use boru\borumcp\MCP;
use boru\borumcp\ToolRegistry;
use \stdClass;

/**
 * Stateless dispatcher; sessions provide I/O + buffering.
 */
final class McpDispatcher {
    private $serverName='php-mcp-react';
    private $serverVersion='0.3.0';
    private $protocolVersion='2025-06-18';
    /** @var ToolRegistry */
    private $tools;
    /** @var callable(string):void */
    private $sendFn;

    /** @var array|null */
    private $principal = null;

    public function __construct(ToolRegistry $tools, $sendFn){
        $this->tools=$tools;
        $this->sendFn=$sendFn; // function($line)
    }

    public function setPrincipal($principal) { $this->principal = $principal; }
    public function getPrincipal() { return $this->principal; }

    public function handleLine($line){
        $line=trim($line);
        if($line==='') return;
        $msg=json_decode($line,true);
        if($msg===null){ MCP::elog('Malformed JSON ignored: '.$line); return; }

        $id     = isset($msg['id'])?$msg['id']:null;
        $method = isset($msg['method'])?$msg['method']:null;
        $params = isset($msg['params'])&&is_array($msg['params'])?$msg['params']:array();

        if(!$method){
            if($id!==null) $this->send(JsonRpc::encodeLine(JsonRpc::error($id,-32600,'Invalid Request: missing method')));
            return;
        }

        switch($method){
            case 'initialize':
                $res=array(
                    'protocolVersion'=>$this->protocolVersion,
                    'serverInfo'=>array('name'=>$this->serverName,'version'=>$this->serverVersion),
                    'capabilities'=>array('tools'=>new stdClass(),'resources'=>new stdClass(),'prompts'=>new stdClass()),
                    'instructions'=>'Use tools/list then tools/call.'
                );
                $this->send(JsonRpc::encodeLine(JsonRpc::result($id,$res)));
                break;

            case 'tools/list':
                $this->send(JsonRpc::encodeLine(JsonRpc::result($id,array('tools'=>$this->tools->listTools()))));
                break;

            case 'tools/call':
                $name = isset($params['name'])?(string)$params['name']:'';
                $args = isset($params['arguments'])&&is_array($params['arguments'])?$params['arguments']:array();
                $toolArgs = new ToolArgs($args);
                if($name===''){ $this->send(JsonRpc::encodeLine(JsonRpc::error($id,-32602,'Invalid params: missing tool name'))); break; }
                $tool=$this->tools->get($name);
                if(!$tool){
                    $out=array('content'=>array(array('type'=>'text','text'=>'Unknown tool: '.$name)),'isError'=>true);
                    $this->send(JsonRpc::encodeLine(JsonRpc::result($id,$out)));
                    break;
                }
                $call=$tool->call($toolArgs);
                $result=array('content'=>isset($call['content'])?$call['content']:array(),'isError'=>!empty($call['isError']));
                if(isset($call['structuredContent'])) $result['structuredContent']=$call['structuredContent'];
                $this->send(JsonRpc::encodeLine(JsonRpc::result($id,$result)));
                break;

            case 'ping':
                $this->send(JsonRpc::encodeLine(JsonRpc::result($id,array())));
                break;

            default:
                $this->send(JsonRpc::encodeLine(JsonRpc::error($id,-32601,'Method not found',array('method'=>$method))));
        }
    }

    private function send($line){ call_user_func($this->sendFn,$line); }
}