<?php
namespace boru\borumcp\Core;
use boru\dot\Dot;

class ToolArgs implements \ArrayAccess, \IteratorAggregate, \Countable, \JsonSerializable {
    private $args = [];

    public function __construct(array $params) {
        $this->args = $params;
    }

    public function offsetExists($offset) {
        return isset($this->args[$offset]);
    }

    public function offsetGet($offset) {
        return isset($this->args[$offset]) ? $this->args[$offset] : null;
    }

    public function offsetSet($offset, $value) {
        $this->args[$offset] = $value;
    }

    public function offsetUnset($offset) {
        unset($this->args[$offset]);
    }

    public function toArray() {
        return $this->args;
    }

    public function getIterator() {
        return new \ArrayIterator($this->args);
    }

    public function count() {
        return count($this->args);
    }

    public function jsonSerialize() {
        return $this->args;
    }

    public function get($key=null, $default=null) {
        if ($key === null) {
            return $this->args;
        }
        return Dot::get($this->args, $key, $default);
    }
    public function set($key, $value) {
        Dot::set($this->args, $key, $value);
    }
}