<?php
namespace boru\borumcp\Interfaces;

interface AuthenticatorInterface {
    /**
     * @param string|null $token  Raw bearer token (e.g., from initialize.params.authToken)
     * @return array|null         Principal array (e.g. ['sub'=>'user-or-service','roles'=>['mcp']]) or null if invalid
     */
    public function verify($token);

    /**
     * Optional method to get a JWT signer if the authenticator supports it.
     * @return object|null  An instance of a JWT signer class or null if not supported
     */
    public function getSigner();

    /**
     * Optional method to get a JWT minter if the authenticator supports it.
     * @return object|null  An instance of a JWT minter class or null if not supported
     */
    public function getMinter();
}