<?php
namespace boru\borumcp;

use boru\output\Output;
use boru\borumcp\ToolRegistry;
use boru\borumcp\Core\ToolInterface;
use boru\borumcp\Core\McpDispatcher;
use boru\borumcp\Core\McpSession;
use boru\borumcp\Core\JsonRpc;

class MCP {
    /** @var ToolRegistry */
    private static $toolRegistry=null;

    /** @var McpDispatcher */
    private static $dispatcher=null;

    /** @var bool */
    private static $serverRunning=false;

    /** @var Server */
    private static $server=null;

    public static function elog($m){ fwrite(STDERR, "[MCP] ".$m.PHP_EOL); }
    public static function log($m){ Output::outLine("[MCP]", $m); }

    public static function isServerRunning() { return self::$serverRunning; }

    public static function toolRegistry() {
        if(self::$toolRegistry===null){
            self::$toolRegistry = new ToolRegistry();
        }
        return self::$toolRegistry;
    }

    public static function startServer($bindIp='127.0.0.1', $bindPort=9000,$tools=null) {
        self::$server = new Server($bindIp,$bindPort,$tools);
        self::$serverRunning = true;
        if($tools instanceof ToolRegistry){ self::$toolRegistry = $tools; }
        self::$server->start();
        return self::$server;
    }

    /**
     * Build a ready-to-send Responses API JSON payload (as string) that
     * references this MCP server by `server_name` and (optionally) includes a bearer token.
     *
     * @param string      $serverName  The MCP server provider name registered in OpenAI (e.g., "php-mcp")
     * @param string|null $token       Optional bearer token; if null, tool_auth is set to "none"
     * @param string      $model       OpenAI model id (e.g., "gpt-4.1-mini")
     * @param array|null  $messages    Optional OpenAI messages array; if null, a friendly default is used
     * @param array|null  $extra       Optional extra top-level OpenAI request keys (e.g., temperature)
     * @return string                  JSON pretty-printed string for POST /v1/responses
     */
    public static function responsesApiJson($serverName, $token = null, $model = 'gpt-4.1-mini', array $messages = null, array $extra = null)
    {
        if ($messages === null) {
            $messages = array(
                array('role' => 'user', 'content' => 'Call echo_text with "hello world", then reply with the result.')
            );
        }

        $tool = array(
            'type' => 'mcp',
            'server_name' => (string)$serverName
        );

        if ($token !== null && $token !== '') {
            $tool['tool_auth'] = array(
                'strategy' => 'bearer',
                'token'    => (string)$token
            );
        } else {
            $tool['tool_auth'] = array(
                'strategy' => 'none'
            );
        }

        $payload = array(
            'model' => (string)$model,
            'messages' => $messages,
            'tools' => array($tool),
        );

        if (is_array($extra) && $extra) {
            foreach ($extra as $k => $v) {
                // Don't clobber model/messages/tools
                if (!in_array($k, array('model','messages','tools'), true)) {
                    $payload[$k] = $v;
                }
            }
        }

        return json_encode($payload, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    }
}