<?php
namespace boru\borumcp\Tools;

class Tool implements \boru\borumcp\Interfaces\ToolInterface {
    private $describeCallback = null;
    private $callCallback = null;

    public function __construct($describeCallback = null, $callCallback = null) {
        $this->describeCallback = $describeCallback;
        $this->callCallback = $callCallback;
    }


    public function setDescribe($callbackFn) {
        $this->describeCallback = $callbackFn;
    }
    public function setCall($callbackFn) {
        $this->callCallback = $callbackFn;
    }


    public function describe(){
        if (is_callable($this->describeCallback)) {
            return call_user_func($this->describeCallback);
        }
        return [
            'name' => 'base_tool',
            'description' => 'Base Tool Class',
            'parameters' => []
        ];
    }
    public function call($params){
        if (is_callable($this->callCallback)) {
            return call_user_func($this->callCallback, $params);
        }
        return null;
    }
}