#!/usr/bin/env php
<?php

use boru\borumcp\Tools\Tool;

require __DIR__.'/init.php';

$tools->register(new Tool(
    function() {
        return [
            'name' => 'echo_text',
            'description' => 'Echo back the provided text.',
            'inputSchema' => [
                'type' => 'object',
                'properties' => [
                    'text' => ['type' => 'string']
                ],
                'required' => ['text'],
                'additionalProperties' => false
            ]
        ];
    },
    function($params) {
        $text = isset($params['text']) ? (string)$params['text'] : '';
        return [
            'content' => [['type' => 'text', 'text' => $text]],
            'structuredContent' => ['echoedText' => $text],
            'isError' => false
        ];
    }
));

$json = $server->buildResponsesToolObjectJWT();
echo json_encode($json, JSON_PRETTY_PRINT) . "\n";
echo "\n";
$server->start();