<?php
namespace boru\borumcp\Core;

final class JwtSigner
{
    private $alg;             // 'HS256'|'RS256'
    private $signKey;         // HS: secret; RS: private key (PEM)
    private $kid;             // header kid|null
    private $iss;             // default issuer|null
    private $aud;             // default audience|null
    private $ttl;             // default lifetime seconds

    public function __construct($alg, $signKey, $kid = null, $iss = null, $aud = null, $ttl = 300) {
        $this->alg = strtoupper($alg);
        $this->signKey = $signKey;
        $this->kid = $kid;
        $this->iss = $iss;
        $this->aud = $aud;
        $this->ttl = (int)$ttl;
    }

    /**
     * @param array $claimsExtra merged into standard claims
     * @param int|null $ttl custom TTL in seconds
     * @return string JWT
     */
    public function mint(array $claimsExtra = array(), $ttl = null) {
        $now = time();
        $exp = $now + (is_int($ttl) ? $ttl : $this->ttl);

        $claims = array(
            'iss' => $this->iss,
            'aud' => $this->aud,
            'iat' => $now,
            'nbf' => $now,
            'exp' => $exp
        );
        foreach ($claimsExtra as $k=>$v) { $claims[$k] = $v; }

        $hdr = array('alg'=>$this->alg);
        if ($this->kid !== null && $this->kid !== '') $hdr['kid'] = $this->kid;

        return JWT::encode($hdr, $claims, $this->signKey);
    }
}
