<?php
namespace boru\borumcp\Proxy;

final class HttpContext
{
    public $method;
    public $path;
    /** @var array<string,string> */
    public $headers;
    public $bodyRaw;
    public $remoteAddr;

    public static function fromGlobals()
    {
        $ctx = new self();
        $ctx->method     = isset($_SERVER['REQUEST_METHOD']) ? strtoupper($_SERVER['REQUEST_METHOD']) : 'GET';
        $ctx->path       = self::resolvePath();
        $ctx->headers    = self::collectHeaders();
        $ctx->bodyRaw    = file_get_contents('php://input') ?: '';
        $ctx->remoteAddr = $_SERVER['REMOTE_ADDR'] ?? null;
        return $ctx;
    }

    private static function resolvePath()
    {
        if (isset($_REQUEST['path'])) return (string)$_REQUEST['path'];

        $uriPath   = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH) ?: '/';
        $script    = $_SERVER['SCRIPT_NAME'] ?? '';
        $scriptDir = rtrim(str_replace('\\','/', dirname($script)), '/');

        if ($script && strpos($uriPath, $script) === 0) {
            $p = substr($uriPath, strlen($script));
            return $p !== '' ? $p : '/';
        }
        if ($scriptDir && strpos($uriPath, $scriptDir) === 0) {
            $p = substr($uriPath, strlen($scriptDir));
            return $p !== '' ? $p : '/';
        }
        return $uriPath ?: '/';
    }

    /** @return array<string,string> */
    private static function collectHeaders()
    {
        if (function_exists('getallheaders')) {
            $h = getallheaders();
            if (is_array($h)) return $h;
        }
        $h = [];
        foreach ($_SERVER as $k => $v) {
            if (substr($k, 0, 5) === 'HTTP_') {
                $name = str_replace(' ', '-', ucwords(strtolower(str_replace('_', ' ', substr($k, 5)))));
                $h[$name] = $v;
            }
        }
        return $h;
    }

    public function headerValue(string $name)
    {
        foreach ($this->headers as $k => $v) {
            if (strcasecmp($k, $name) === 0) return $v;
        }
        return null;
    }

    public function wantsEventStream()
    {
        $accept = $this->headerValue('Accept');
        return $accept && stripos($accept, 'text/event-stream') !== false;
    }

    public function bearerOrNull()
    {
        $h = $this->headerValue('Authorization');
        if (!$h) return null;
        return (stripos($h, 'Bearer ') === 0) ? substr($h, 7) : null;
    }
}
