<?php
namespace boru\borumcp\Proxy;

final class HttpProxyApp
{
    private $cfg;
    private $rest;
    private $rpc;

    public function __construct(ProxyConfig $cfg)
    {
        $this->cfg = $cfg;
        $this->rest = new ToolsRestController($cfg);
        $this->rpc  = new McpJsonRpcBridgeController($cfg);
    }

    public function handle()
    {
        $ctx = HttpContext::fromGlobals();

        if ($this->cfg->logger) {
            $this->cfg->logger->log("cli->app","Incoming {$ctx->method} {$ctx->path}", [
                'headers' => $ctx->headers,
                'body'    => $ctx->bodyRaw,
                'remote_addr' => $ctx->remoteAddr
            ]);
        }

        // Route: JSON-RPC bridge lives at "/" (POST) and SSE at "/" (GET Accept: event-stream)
        if ($ctx->path === '/') {
            if ($this->cfg->logger) {
                $this->cfg->logger->log("info","Routing to JSON-RPC bridge", [
                    'method' => $ctx->method,
                    'remote' => $ctx->remoteAddr ?? 'unknown'
                ]);
            }
            $this->rpc->handle($ctx);
            return; // never returns on SSE
        }

        // Legacy REST endpoints
        if ($ctx->path === '/tools/list' || $ctx->path === '/tools/call' || $ctx->path === '/health' || $ctx->path === '/mcp/health') {
            if ($this->cfg->logger) {
                $this->cfg->logger->log("info","Routing to REST controller", [
                    'method' => $ctx->method,
                    'path'   => $ctx->path,
                    'remote' => $ctx->remoteAddr ?? 'unknown'
                ]);
            }
            $this->rest->handle($ctx);
            return;
        }

        if ($this->cfg->logger) {
            $this->cfg->logger->log("error","No route found for request", [
                'method' => $ctx->method,
                'path'   => $ctx->path,
                'remote' => $ctx->remoteAddr ?? 'unknown'
            ]);
        }
        HttpResponder::error(404, 'Not Found');
    }

    //Helper Statics to create
    public static function makeConfig(array $options = [])
    {
        $config = new ProxyConfig();
        foreach ($options as $key => $value) {
            if (method_exists($config, $key)) {
                call_user_func([$config, $key], $value);
            }
        }
        return $config;
    }
}
