<?php
namespace boru\borumcp\Proxy;

use boru\borumcp\Logger\LoggerInterface;

final class SseStreamer
{
    /** @var LoggerInterface|null */
    private $logger;
    public function __construct(?LoggerInterface $logger = null) { $this->logger = $logger; }

    public function keepAliveLoop(string $remote = 'unknown', float $intervalSec = 2.5)
    {
        if ($this->logger) $this->logger->log("SSE stream opened", ['remote' => $remote]);

        header('Content-Type: text/event-stream');
        header('Cache-Control: no-cache');
        header('Connection: keep-alive');

        echo ": ok\n\n";
        @ob_flush(); @flush();

        $start = microtime(true);
        $pings = 0;

        while (!connection_aborted()) {
            $pings++;
            $uptime = round(microtime(true) - $start, 2);
            echo "event: keepalive\n";
            echo 'data: {"ping":'.$pings.',"uptime":'.$uptime."}\n\n";
            @ob_flush(); @flush();

            if ($this->logger && $pings % 20 === 0) {
                $this->logger->log("SSE keepalive ping", ['remote'=>$remote,'pings'=>$pings,'uptime'=>$uptime]);
            }

            usleep((int)($intervalSec * 1_000_000));
        }

        if ($this->logger) {
            $this->logger->log("SSE stream closed", ['remote' => $remote, 'pings' => $pings]);
        }
        exit;
    }
}
