<?php
namespace boru\borumcp;

use boru\borumcp\Interfaces\ToolInterface;

final class ToolRegistry {
    private $map = [];
    public function __construct(){
        //$this->register(new EchoTextTool());
        //$this->register(new TimeNowTool());
    }
    public function register(ToolInterface $t){
        $d=$t->describe(); $n=isset($d['name'])?$d['name']:null; if($n){ $this->map[$n]=$t; }
    }
    public function registerDirectory($dir){
        if(is_dir($dir) && ($dh=opendir($dir))){
            while(($file=readdir($dh))!==false){
                if($file==='.' || $file==='..') continue;
                $path=$dir.DIRECTORY_SEPARATOR.$file;
                if(is_file($path) && preg_match('/\.php$/i',$file)){
                    require_once($path);
                    $className = pathinfo($file, PATHINFO_FILENAME);
                    if (class_exists($className)) {
                        $obj = new $className();
                        if ($obj instanceof ToolInterface) {
                            $this->register($obj);
                        }
                    }
                }
            }
            closedir($dh);
        }
    }
    public function listTools(){ $out=[]; foreach($this->map as $t){ $out[]=$t->describe(); } return $out; }
    public function get($name){ return isset($this->map[$name])?$this->map[$name]:null; }
}