<?php
namespace boru\borumcp\Tools;
use boru\borumcp\Interfaces\ToolInterface;
use stdClass;

final class TimeNowTool implements ToolInterface {
    public function describe(){
        return [
            'name'=>'time_now',
            'description'=>'Return current server time in ISO 8601 (UTC).',
            'inputSchema'=>[
                'type'=>'object',
                'properties'=> [
                    'information' => [
                        'type' => 'string',
                        'description' => 'Optional information to provide context.'
                    ]
                ],
                'required'=>['information'],
                'additionalProperties'=>false
            ]
        ];
    }
    public function call($args){
        $now = gmdate('c');
        return [
            'content'=>[['type'=>'text','text'=>'Current UTC time: '.$now]],
            'structuredContent'=>['iso8601'=>$now],
            'isError'=>false
        ];
    }
}