<?php
namespace boru\borumcp\Logger;

final class FileLogger implements LoggerInterface
{
    public static $logHeaders = false;
    private $path;
    public function __construct(string $path) { $this->path = $path; }

    public function log(string $message, ?array $context = null)
    {
        if(!self::$logHeaders && isset($context['headers']) && is_array($context['headers'])) {
            unset($context['headers']);
        }
         // --- Find the calling class/method/line ---
        $trace = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 5);
        $caller = 'unknown';
        $line   = null;

        foreach ($trace as $frame) {
            // Skip the logger itself
            if (isset($frame['class']) && $frame['class'] !== __CLASS__) {
                $class = $frame['class'];
                $func  = isset($frame['function']) ? $frame['function'] : '';
                $caller = $class . ($func ? '::' . $func : '');
                if (isset($frame['line'])) {
                    $line = $frame['line'];
                }
                break;
            } elseif (!isset($frame['class']) && isset($frame['function']) && $frame['function'] !== 'log') {
                // global function call fallback
                $caller = $frame['function'];
                if (isset($frame['line'])) {
                    $line = $frame['line'];
                }
                break;
            }
        }

        if ($line !== null) {
            $caller .= ':' . $line;
        }
        $time = date('Y-m-d H:i:s');
        $line = "[$time] [$caller] $message";
        if ($context !== null) {
            $line .= ' ' . json_encode($context, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
        }
        $line .= "\n";
        @file_put_contents($this->path, $line, FILE_APPEND);
    }
}
