<?php
namespace boru\borumcp\Proxy;

use boru\borumcp\Logger\LoggerInterface;

final class ProxyConfig
{
    public $upstreamHost = '127.0.0.1';
    public $minPort = 8000;
    public $maxPort = 65000;
    public $internalPortHeader = 'internal-port';

    // seconds / ms
    public $connectTimeout = 3.0;
    public $readTimeout    = 2.0;
    public $initTimeoutMs  = 4000;
    public $listTimeoutMs  = 4000;
    public $callTimeoutMs  = 8000;

    public $protocolVersion = '2025-06-18';

    /** @var LoggerInterface|null */
    public $logger = null;

    // Fluent setters
    public function upstreamHost(string $host) { $this->upstreamHost = $host; return $this; }
    public function allowedPortRange(int $min, int $max) { $this->minPort=$min; $this->maxPort=$max; return $this; }
    public function internalPortHeader(string $name) { $this->internalPortHeader=$name; return $this; }
    public function timeouts(float $connect, float $read, int $initMs, int $listMs, int $callMs) {
        $this->connectTimeout=$connect; $this->readTimeout=$read;
        $this->initTimeoutMs=$initMs; $this->listTimeoutMs=$listMs; $this->callTimeoutMs=$callMs; return $this;
    }
    public function protocolVersion(string $pv) { $this->protocolVersion=$pv; return $this; }
    public function logger(LoggerInterface $logger) { $this->logger=$logger; return $this; }
}
