<?php
namespace boru\borussh;


use \phpseclib3\Crypt\PublicKeyLoader;
use \phpseclib3\Net\SSH2;

class SSH {
	private $debug;
	private $debug_nl;
	//var $debug = true;

	/**
	 * 
	 * @var \phpseclib3\Net\SSH2
	 */
	private $ssh;
	private $connected = false;

	private static $methods = array(
		/*'kex' => 'diffie-hellman-group1-sha1',
		'hostkey' => 'ssh-dss',
		'client_to_server' => array(
			'crypt' => '3des-cbc',
			'mac' => 'hmac-md5',
			'comp' => 'none'
		),
		'server_to_client' => array(
			'crypt' => '3des-cbc',
			'mac' => 'hmac-md5',
			'comp' => 'none'
		)*/
	);


	public function __construct($debug=false) {
		$this->debug = $debug;
		$this->debug_nl = php_sapi_name() === "cli" ? PHP_EOL : "<br>";
	}
	public function debug($debug=null) {
		if(is_null($debug)) {
			return $this->debug;
		}
		$this->debug = $debug;
		return $this;
	}
	public function login($user,$pass,$host,$port=22,$timeout=10) {
		$this->ssh = new SSH2($host,$port,$timeout);
		if(strpos($pass,"/") !== false && file_exists($pass)) {
			$key = PublicKeyLoader::load(file_get_contents($pass));
			if(!$this->ssh->login($user,$key)) {
				return false;
			}
		} else {
			if(!$this->ssh->login($user,$pass)) {
				return false;
			}
		}
		if($this->debug) { echo "[DEBUG] Connected to $host:$port with $user/$pass".$this->debug_nl; flush(); }
		$this->connected = true;
		return true;
	}
	public function quietMode($enable=true) {
		if($enable) {
			$this->ssh->enableQuietMode();
		} else {
			$this->ssh->disableQuietMode();
		}
	}
	public function e($cmd) {
		return $this->exec_cmd($cmd);
	}
	public function exec_cmd($cmd,$callback=null) {
		$this->d("exec_cmd = ".$cmd);
		if($this->connected && !is_null($this->ssh)) {
			$this->ssh->setTimeout(0);
			return $this->ssh->exec($cmd);
		}
		return false;
	}
	function sudoExec($cmd) {
		$cmd = $this->sudoize($cmd," && ");
		$cmd = $this->sudoize($cmd," | ");
		return $this->exec_cmd($cmd);
	}
	private function sudoize($cmd,$separator=" && ") {
		$parts = explode(" && ",$cmd);
		foreach($parts as $k=>$part) {
			$parts[$k]=$this->sudoizeCommand($part);
		}
		return implode(" && ",$parts);
	}
	private function sudoizeCommand($cmd) {
		if(substr(trim($cmd),0,5) != "sudo " && substr(trim($cmd),0,3) != "cd ") {
			$cmd = "sudo ".$cmd;
		}
		return $cmd;
	}
	public function d($message) {
		if($this->debug) {
			echo "[DEBUG] $message".$this->debug_nl; flush();
		}
	}
	public function disconnect() {
		if($this->connected && !is_null($this->ssh)) {
			$this->ssh->disconnect();
		}
	}
	public function getStdError() {
		return $this->ssh->getStdError();
	}

	/**
	 * 
	 * @return \phpseclib3\Net\SSH2
	 */
	public function getSsh() {
		return $this->ssh;
	}
}