<?php
namespace boru\borusvn;

use boru\borudiff\Diff;
use boru\borussh\SSH;
use boru\borusvn\lib\SimpleXML;

class SVN {
	public $url;
	public $debug=false;
	
	private $connected;
	private $shell;
	private $user;
	private $pass;
	private $host;
	private $svnuser;
	private $svnpass;
	private $port=22;
	function __construct($user,$pass,$host,$port=22) {
		$this->user = $user;
		$this->pass = $pass;
		$this->host = $host;
		$this->port = $port;
		$this->svnuser = $user;
		$this->svnpass = $pass;
	}
	function setAuth($user,$pass) {
		$this->svnuser = $user;
		$this->svnpass = $pass;
	}
	
	function log($url,$limit=5,$revision_start=null) {
		if($revision_start !== null) {
			$rev = "-r $revision_start";
		} else {
			$rev = "-r HEAD";
		}
		$output = $this->xml($this->svncmd("log -l$limit $rev:0 --xml --verbose $url"));
		
		if(!isset($output->logentry)) {
			return array();
		}
		$outarr = array();
		//echo "<pre>";var_dump($output);echo "</pre>";
		if(!is_array($output->logentry)) {
			$logentry_arr[] = $output->logentry;
		} else {
			$logentry_arr = $output->logentry;
		}
		//echo "<pre>";var_dump($logentry_arr);echo "</pre>";
		foreach($logentry_arr as $k=>$obj) {
			$revision =$obj->{"@attributes"}->revision;
			$author = $obj->author;
			$date = $this->convertDateFormat($obj->date);
			$changes = $this->pathsToArray($obj->paths);
			$arr = array();
			$arr["revision"] = $revision;
			$arr["author"] = $author;
			$arr["date"] = $date;
			$arr["changes"] = $changes;
			$outarr[] = $arr;
		}
		return $outarr;
	}
	function files($url,$full=false,$revision=null) {
		$cmd = "list --xml";
		if($full) $cmd.=" --depth infinity";
		$cmd .=" ".$url;
		if($revision !== null) $cmd.=" -r $revision";

		$data = $this->xml($this->svncmd($cmd));
		
		$entries = array();
		if(!is_array($data->{"list"}->entry)) {
			$entries[] = $data->{"list"}->entry;
		} else {
			$entries = $data->{"list"}->entry;
		}
		
		//echo "<pre>"; var_dump($entries); echo "</pre>";
		$output = array();
		foreach($entries as $k=>$entry) {
			$name = $entry->name;
			$kind = $entry->{"@attributes"}->kind;
			if($kind == "file") $size = $entry->size;
			else $size=0;
			$revision = $entry->commit->{"@attributes"}->revision;
			$author = $entry->commit->author;
			$date = $this->convertDateFormat($entry->commit->date);
			$output[$name]["type"] = $kind;
			$output[$name]["size"] = $size;
			$output[$name]["revision"] = $revision;
			$output[$name]["author"] = $author;
			$output[$name]["date"] = $date;
		}
		if($full) {
			$split_array = array();
			
			foreach($output as $path=>$info) {
				if($info["type"] != "dir") {
					$parts = explode("/",$path);
					$leaf = array_pop($parts);
					$parentArr = &$split_array;
					foreach($parts as $part) {
						if(!isset($parentArr[$part])) {
							$parentArr[$part] = array();
						} elseif (!is_array($parentArr[$part])) {
							$parentArr[$part] = array();
						}
						$parentArr = &$parentArr[$part];
					}
					$parentArr[$leaf] = $info;
				}
			}
			return $split_array;
		} else {
			$folders = array();
			$files = array();
			foreach($output as $path=>$info) {
				if($info["type"] == "dir") {
					$folders[] = $path;
				} else {
					$files[] = $path;
				}
			}
			natcasesort($folders);
			natcasesort($files);
			$newoutput = array();
			foreach($folders as $k=>$path) {
				$newoutput[$path]=$output[$path];
			}
			foreach($files as $k=>$path) {
				$newoutput[$path]=$output[$path];
			}
			return $newoutput;
		}
	}
	
	function diff($url,$revision_start=0,$revision_end="HEAD",$type="side",$ignoreWhitespace=true,$ignoreCase=false,$blame=false){
		if($blame) {
			$data1 = explode("\n",$this->blame($url,$revision_start));
			$data2 = explode("\n",$this->blame($url,$revision_end));
		} else {
			$data1 = explode("\n",$this->cat($url,$revision_start));
			$data2 = explode("\n",$this->cat($url,$revision_end));
		}
		
		$options = array('ignoreWhitespace'=>$ignoreWhitespace,'ignoreCase'=>$ignoreCase);
		
		$diff = new Diff($data1,$data2,$options);
		if($type == "side") {
			return $diff->toHtmlSideBySide();
		} else {
            return $diff->toHtmlInline();
        }
	}
	function diffFiles($url1,$revision1,$url2,$revision2,$type="side",$ignoreWhitespace=true,$ignoreCase=false,$blame=false){
		if($blame) {
			$data1 = explode("\n",$this->blame($url1,$revision1));
			$data2 = explode("\n",$this->blame($url2,$revision2));
		} else {
			$data1 = explode("\n",$this->cat($url1,$revision1));
			$data2 = explode("\n",$this->cat($url2,$revision2));
		}
		$options = array('ignoreWhitespace'=>$ignoreWhitespace,'ignoreCase'=>$ignoreCase);
		
		$diff = new Diff($data1,$data2,$options);
		if($type == "side") {
			return $diff->toHtmlSideBySide();
		} else {
            return $diff->toHtmlInline();
        }
	}
	function summary($url,$revision_start=0,$revision_end="HEAD") {
		$output = $this->xml($this->svncmd("diff --summarize --revision $revision_start:$revision_end --xml $url"));
		$outarr = $this->pathsToArray($output->paths,$url);
		return $outarr;
		
	}
	
	function cat($url,$revision="HEAD") {
		if($revision != "HEAD") {
			$rev = "--revision $revision";
		}
		return $this->svncmd("cat $rev $url");
	}
	
	function blame($url,$revision="HEAD") {
		if($revision != "HEAD") {
			$rev = "--revision $revision";
		}
		return $this->svncmd("blame $rev $url");
	}
	
	function info($url) {
		return $this->xml($this->svncmd("info --xml $url"));
	}
	
	function svncmd($command) {
		$cmd = "svn --username=".$this->svnuser." --password=".$this->svnpass." ".$command;
		$this->printDebug($cmd);
		return $this->exec($cmd);
	}
	
	/* data utilities*/
	function xml($string) {
		$sxml = new SimpleXML();
		return $sxml->xml_load_file($string);
	}
	function convertDateFormat($input) {
		return date("Y-m-d H:i:s",strtotime($input));
	}
	function pathsToArray($pathsObj,$url="") {
		if(!isset($pathsObj->path)) {
			return false;
		}
		$paths = array();
		if(is_object($pathsObj->path)) {
			$paths[] = $pathsObj->path;
		} else {
			$paths = $pathsObj->path;
		}
		
		
		$output = array();
		foreach($paths as $k=>$path) {
			$file = $path->{"@content"};
			if($url != "") $file=str_replace($url,"",$file);
			if(isset($path->{"@attributes"}->item)) {
				$type = $path->{"@attributes"}->item;
				if($type == "modified") { $td = "M"; }
				if($type == "added") { $td = "A"; }
				if($type == "deleted") { $td = "D"; }
			}
			if(isset($path->{"@attributes"}->action)) {
				$td = $path->{"@attributes"}->action;
			}
			$arr=array();
			$arr["file"] = $file;
			$arr["type"] = $td;
			$output[] = $arr;
		}
		return $output;
	}
	
	/*Server connection utilities*/
	function connect($shell=false) {
		if(!$shell) {
			$this->shell = new SSH();
		} else {
			$this->shell = $shell;
		}
		$this->shell->debug(false);
		if(!$this->connected) {
			if( ($this->connected = $this->shell->login($this->user,$this->pass,$this->host,$this->port)) === false) {
				throw new \Exception("SSH: unable to connect to ".$this->host.":".$this->port);
			}
		}
		return true;
	}
	function disconnect() {
		if($this->connected) {
			$this->shell->disconnect();
		}
	}
	function exec($cmd,$block=true) {
		if(!$this->connected) {
			$this->connect();
		}
		if($this->connected) {
			return $this->shell->exec_cmd($cmd,$block);
		}
	}
	
	function printDebug($data) {
		if($this->debug)
			echo date("H:i:s")." - ".$data."\n";
	}
}