<?php
namespace boru\vtigertools\structure;

class Field {
    
    protected $fieldName;
    protected $fieldLabel;
    protected $columnName;
    protected $columnType = "VARCHAR(100)";
    protected $tableName;
    protected $uiType = 1;
    protected $typeOfData = "V~O";
    protected $helpInfo = '';
    protected $massEdit = 1;

    /**
     * Valid options:
     * * 1 - default, editable
     * * 2 - non-editable, sets mandatory=3 in visibility dealio
     * * 3 - readonly/disabled
     * * 4 - password hashed
     * * 5 - not searchable/filterable
     * * 6 - starred/tags
     * editable: 1,3,5
     * special: 2,4,6
     * @var int
     */
    protected $displayType = 1;

    /**
     * Valid options:
     * * 1 - standard/non-custom
     * * 2 - custom field
     * @var int
     */
    protected $generatedType = 2;
    protected $readOnly = 0;

    /**
     * Valid options:
     * * 0 - standard vtiger field
     * * 1 - hidden
     * * 2 - added custom field
     * @var mixed
     */
    protected $presence = 2;
    protected $defaultValue;

    /**
     * 0 = mandatory, 1 = disabled, 2 = enabled
     * @var int
     */
    protected $quickCreate = 2;
    protected $sequence;
    protected $summaryField = 0;
    protected $isUnique = 0;
    protected $headerField = 0;


    /** @var \Vtiger_Field */
    protected $instance;
    protected $picklistValues = [];
    protected $relatedModules = [];

    public function __construct($fieldName,$fieldLabel,$options=[]) {
        $this->fieldName($fieldName);
        $this->columnName($fieldName);
        $this->fieldLabel($fieldLabel);
        if(!empty($options)) {
            $this->setFromArray($options);
        }
    }

    public function getVTFieldInstance($force=false) {
        if(is_null($this->instance) || $force) {
            $this->instance = new \Vtiger_Field();
            $this->instance->initialize($this->get());
            if(!is_null($this->columnType)) {
                $this->instance->columnType = $this->columnType();
            }
            if(!empty($this->picklistValues)) {
                $this->instance->setPicklistValues($this->picklistValues());
            }
            if(!empty($this->relatedModules)) {
                $this->instance->setRelatedModules($this->relatedModules());
            }
        }
        return $this->instance;
    }
    public function get() {
        return [
            "fieldname"     => $this->fieldName(),
            "fieldlabel"    => $this->fieldLabel(),
            "columnname"    => $this->columnName(),
            "tablename"     => $this->tableName(),
            "uitype"        => $this->uiType(),
            "typeofdata"    => $this->typeOfData(),
            "helpinfo"      => $this->helpInfo(),
            "masseditable"  => $this->massEdit(),
            "displaytype"   => $this->displayType(),
            "generatedtype" => $this->generatedType(),
            "readonly"      => $this->readOnly(),
            "presence"      => $this->presence(),
            "defaultvalue"  => $this->defaultValue(),
            "quickcreate"   => $this->quickCreate(),
            "sequence"      => $this->sequence(),
            "summaryfield"  => $this->summaryField(),
            "isunique"      => $this->isUnique(),
            "headerfield"   => $this->headerField(),
        ];
    }
    public function fieldName($fieldName=null) {
        return is_null($fieldName) ? $this->getFieldName() : $this->setFieldName($fieldName);
    }
    public function fieldLabel($fieldLabel=null) {
        return is_null($fieldLabel) ? $this->getFieldLabel() : $this->setFieldLabel($fieldLabel);
    }
    public function columnName($columnName=null) {
        return is_null($columnName) ? $this->getColumnName() : $this->setColumnName($columnName);
    }
    public function tableName($tableName=null) {
        return is_null($tableName) ? $this->getTableName() : $this->setTableName($tableName);
    }
    public function uiType($uiType=null) {
        return is_null($uiType) ? $this->getUiType() : $this->setUiType($uiType);
    }
    public function typeOfData($typeOfData=null) {
        return is_null($typeOfData) ? $this->getTypeOfData() : $this->setTypeOfData($typeOfData);
    }
    public function helpInfo($helpInfo=null) {
        return is_null($helpInfo) ? $this->getHelpInfo() : $this->setHelpInfo($helpInfo);
    }
    public function massEdit($massEdit=null) {
        return is_null($massEdit) ? $this->getMassEdit() : $this->setMassEdit($massEdit);
    }
    public function displayType($displayType=null) {
        return is_null($displayType) ? $this->getDisplayType() : $this->setDisplayType($displayType);
    }
    public function generatedType($generatedType=null) {
        return is_null($generatedType) ? $this->getGeneratedType() : $this->setGeneratedType($generatedType);
    }
    public function readOnly($readOnly=null) {
        return is_null($readOnly) ? $this->getReadOnly() : $this->setReadOnly($readOnly);
    }
    public function presence($presence=null) {
        return is_null($presence) ? $this->getPresence() : $this->setPresence($presence);
    }
    public function defaultValue($defaultValue=null) {
        return is_null($defaultValue) ? $this->getDefaultValue() : $this->setDefaultValue($defaultValue);
    }
    public function quickCreate($quickCreate=null) {
        return is_null($quickCreate) ? $this->getQuickCreate() : $this->setQuickCreate($quickCreate);
    }
    public function sequence($sequence=null) {
        return is_null($sequence) ? $this->getSequence() : $this->setSequence($sequence);
    }
    public function summaryField($summaryField=null) {
        return is_null($summaryField) ? $this->getSummaryField() : $this->setSummaryField($summaryField);
    }
    public function isUnique($isUnique=null) {
        return is_null($isUnique) ? $this->getIsUnique() : $this->setIsUnique($isUnique);
    }
    public function headerField($headerField=null) {
        return is_null($headerField) ? $this->getHeaderField() : $this->setHeaderField($headerField);
    }
    public function picklistValues($picklistValues=null) {
        return is_null($picklistValues) ? $this->getPicklistValues() : $this->setPicklistValues($picklistValues);
    }
    public function relatedModules($relatedModules=null) {
        return is_null($relatedModules) ? $this->getRelatedModules() : $this->setRelatedModules($relatedModules);
    }
    public function columnType($columnType=null) {
        return is_null($columnType) ? $this->getColumnType() : $this->setColumnType($columnType);
    }

    protected function isYesValue($value) {
        if(in_array(strtolower($value),["yes","on","y","true"])) {
            return true;
        }
        if($value) {
            return true;
        }
        return false;
    }

    public static $propToMethodMap = [
        "fieldname"     => "fieldName",
        "fieldlabel"    => "fieldLabel",
        "columnname"    => "columnName",
        "tablename"     => "tableName",
        "uitype"        => "uiType",
        "typeofdata"    => "typeOfData",
        "helpinfo"      => "helpInfo",
        "masseditable"  => "massEdit",
        "displaytype"   => "displayType",
        "generatedtype" => "generatedType",
        "readonly"      => "readOnly",
        "presence"      => "presence",
        "defaultvalue"  => "defaultValue",
        "quickcreate"   => "quickCreate",
        "sequence"      => "sequence",
        "summaryfield"  => "summaryField",
        "isunique"      => "isUnique",
        "headerfield"   => "headerField",
    ];
    
    public function setFromArray($array) {
        foreach($array as $key=>$value) {
            if(isset(static::$propToMethodMap[$key])) {
                $method = static::$propToMethodMap[$key];
                $this->$method($value);
            }
        }
        return $this;
    }
    public static function fromArray($array) {
        $instance = false;
        if(isset($array["fieldname"]) && isset($array["fieldlabel"])) {
            $instance = new self($array["fieldname"],$array["fieldlabel"]);
            $instance->setFromArray($array);
        }
        return $instance;
    }

    /**
	 * Get the value of fieldName
     * @return  mixed
     */
    public function getFieldName() {
        return $this->fieldName;
    }

    /**
     * Set the value of fieldName
     * @param   mixed  $fieldName  
     * @return  self
	 */
    public function setFieldName($fieldName) {
        $this->fieldName = $fieldName;
        return $this;
    }

    /**
	 * Get the value of fieldLabel
     * @return  mixed
     */
    public function getFieldLabel() {
        return $this->fieldLabel;
    }

    /**
     * Set the value of fieldLabel
     * @param   mixed  $fieldLabel  
     * @return  self
	 */
    public function setFieldLabel($fieldLabel) {
        $this->fieldLabel = $fieldLabel;
        return $this;
    }

    /**
	 * Get the value of columnName
     * @return  mixed
     */
    public function getColumnName() {
        return $this->columnName;
    }

    /**
     * Set the value of columnName
     * @param   mixed  $columnName  
     * @return  self
	 */
    public function setColumnName($columnName) {
        $this->columnName = $columnName;
        return $this;
    }

    /**
	 * Get the value of uiType
     * @return  mixed
     */
    public function getUiType() {
        return $this->uiType;
    }

    /**
     * Set the value of uiType
     * @param   mixed  $uiType  
     * @return  self
	 */
    public function setUiType($uiType) {
        $this->uiType = $uiType;
        return $this;
    }

    /**
	 * Get the value of tableName
     * @return  mixed
     */
    public function getTableName() {
        return $this->tableName;
    }

    /**
     * Set the value of tableName
     * @param   mixed  $tableName  
     * @return  self
	 */
    public function setTableName($tableName) {
        $this->tableName = $tableName;
        return $this;
    }

    /**
	 * Get the value of typeOfData
     * @return  mixed
     */
    public function getTypeOfData() {
        return $this->typeOfData;
    }

    /**
     * Set the value of typeOfData
     * @param   mixed  $typeOfData  
     * @return  self
	 */
    public function setTypeOfData($typeOfData) {
        $this->typeOfData = $typeOfData;
        return $this;
    }

    /**
	 * Get the value of helpInfo
     * @return  mixed
     */
    public function getHelpInfo() {
        return $this->helpInfo;
    }

    /**
     * Set the value of helpInfo
     * @param   mixed  $helpInfo  
     * @return  self
	 */
    public function setHelpInfo($helpInfo) {
        $this->helpInfo = $helpInfo;
        return $this;
    }

    /**
	 * Get the value of massEdit
     * @return  mixed
     */
    public function getMassEdit() {
        return $this->massEdit;
    }

    /**
     * Set the value of massEdit
     * @param   mixed  $massEdit  
     * @return  self
	 */
    public function setMassEdit($massEdit) {
        $this->massEdit = $this->isYesValue($massEdit) ? 1 : 0;
        return $this;
    }

    /**
	 * Get the value of displayType
     * @return  mixed
     */
    public function getDisplayType() {
        return $this->displayType;
    }

    /**
     * Set the value of displayType
     * @param   mixed  $displayType  
     * @return  self
	 */
    public function setDisplayType($displayType) {
        $this->displayType = $displayType;
        return $this;
    }

    /**
	 * Get the value of generatedType
     * @return  mixed
     */
    public function getGeneratedType() {
        return $this->generatedType;
    }

    /**
     * Set the value of generatedType
     * @param   mixed  $generatedType  
     * @return  self
	 */
    public function setGeneratedType($generatedType) {
        $this->generatedType = $generatedType;
        return $this;
    }

    /**
	 * Get the value of readOnly
     * @return  mixed
     */
    public function getReadOnly() {
        return $this->readOnly;
    }

    /**
     * Set the value of readOnly
     * @param   mixed  $readOnly  
     * @return  self
	 */
    public function setReadOnly($readOnly) {
        $this->readOnly = $readOnly;
        return $this;
    }

    /**
	 * Get the value of presence
     * @return  mixed
     */
    public function getPresence() {
        return $this->presence;
    }

    /**
     * Set the value of presence
     * @param   mixed  $presence  
     * @return  self
	 */
    public function setPresence($presence) {
        $this->presence = $presence;
        return $this;
    }

    /**
	 * Get the value of defaultValue
     * @return  mixed
     */
    public function getDefaultValue() {
        return $this->defaultValue;
    }

    /**
     * Set the value of defaultValue
     * @param   mixed  $defaultValue  
     * @return  self
	 */
    public function setDefaultValue($defaultValue) {
        $this->defaultValue = $defaultValue;
        return $this;
    }

    /**
	 * Get the value of quickCreate
     * @return  mixed
     */
    public function getQuickCreate() {
        return $this->quickCreate;
    }

    /**
     * Set the value of quickCreate
     * @param   mixed  $quickCreate  
     * @return  self
	 */
    public function setQuickCreate($quickCreate) {
        $this->quickCreate = $quickCreate;
        return $this;
    }

    /**
	 * Get the value of sequence
     * @return  mixed
     */
    public function getSequence() {
        return $this->sequence;
    }

    /**
     * Set the value of sequence
     * @param   mixed  $sequence  
     * @return  self
	 */
    public function setSequence($sequence) {
        $this->sequence = $sequence;
        return $this;
    }

    /**
	 * Get the value of summaryField
     * @return  mixed
     */
    public function getSummaryField() {
        return $this->summaryField;
    }

    /**
     * Set the value of summaryField
     * @param   mixed  $summaryField  
     * @return  self
	 */
    public function setSummaryField($summaryField) {
        $this->summaryField = $this->isYesValue($summaryField) ? 1 : 0;
        return $this;
    }

    /**
	 * Get the value of isUnique
     * @return  mixed
     */
    public function getIsUnique() {
        return $this->isUnique;
    }

    /**
     * Set the value of isUnique
     * @param   mixed  $isUnique  
     * @return  self
	 */
    public function setIsUnique($isUnique) {
        $this->isUnique = $this->isYesValue($isUnique) ? 1 : 0;
        return $this;
    }

    /**
	 * Get the value of headerField
     * @return  mixed
     */
    public function getHeaderField() {
        return $this->headerField;
    }

    /**
     * Set the value of headerField
     * @param   mixed  $headerField  
     * @return  self
	 */
    public function setHeaderField($headerField) {
        $this->headerField = $this->isYesValue($headerField) ? 1 : 0;
        return $this;
    }

    /**
	 * Get the value of picklistValues
     * @return  mixed
     */
    public function getPicklistValues() {
        return $this->picklistValues;
    }

    /**
     * Set the value of picklistValues
     * @param   mixed  $picklistValues  
     * @return  self
	 */
    public function setPicklistValues($picklistValues) {
        $this->picklistValues = $picklistValues;
        return $this;
    }

    /**
	 * Get the value of relatedModules
     * @return  mixed
     */
    public function getRelatedModules() {
        return $this->relatedModules;
    }

    /**
     * Set the value of relatedModules
     * @param   mixed  $relatedModules  
     * @return  self
	 */
    public function setRelatedModules($relatedModules) {
        $this->relatedModules = $relatedModules;
        return $this;
    }

    /**
	 * Get the value of columnType
     * @return  mixed
     */
    public function getColumnType() {
        return $this->columnType;
    }

    /**
     * Set the value of columnType
     * @param   mixed  $columnType  
     * @return  self
	 */
    public function setColumnType($columnType) {
        $this->columnType = $columnType;
        return $this;
    }
}