<?php
namespace boru\vtigertools;

use boru\vtigertools\loader\Loader;
use boru\dhdb\dhDB;
use boru\dhutils\async\Queue;
use boru\dhutils\dhGlobal;
use boru\dhutils\filesys\Directory;
use Exception;

class VtigerTools {
    /** @var Loader */
    private static $loader;
    /** @var Directory */
    private static $vtigerRoot;

    private static $previousCwd;

    private static $includes = [];

    private static $debuggerSettings = [
        "trace"=>false,
        "info"=>false,
        "debug"=>false,
        "warn"=>false,
        "error"=>false,
    ];


    public static function init($sourceDirectory=null) {
        static::$loader = new Loader($sourceDirectory);
        static::$vtigerRoot = static::$loader->getVtigerDirectory();
        static::initDebugger();
    }



    public static function getIncludes($force=false) {
        if(empty(static::$includes) || $force) {
            if(!is_null(static::$loader)) {
                $includes = static::$loader->getIncludes();
                foreach($includes as $filename) {
                    static::$includes[] = static::$vtigerRoot->path($filename);
                }
            } else {
                static::$includes = [];
            }
        }
        return static::$includes;
    }
    public static function chdirVTiger() {
        static::$previousCwd = getcwd();
        chdir(static::$vtigerRoot->path());
        return static::$previousCwd;
    }
    public static function resetChdir() {
        if(!is_null(static::$previousCwd)) {
            chdir(static::$previousCwd);
            return true;
        }
        return false;
    }



    public static function debugLevel($level,$enabled=true) {
        if(isset(static::$debuggerSettings[$level])) {
            static::$debuggerSettings[$level] = $enabled;
        }
        static::initDebugger();
    }
    private static function initDebugger() {
        $any = false;
        $debuggers = [];
        foreach(static::$debuggerSettings as $level=>$enabled) {
            if($enabled) {
                $any=true;
                $debuggers[] = $level;
            }
        }
        if(!$any) {
            dhGlobal::logger("debugger",dhGlobal::LOG_ALL & ~dhGlobal::LOG_ERROR & ~dhGlobal::LOG_WARN & ~dhGlobal::LOG_DEBUG & ~dhGlobal::LOG_INFO & ~dhGlobal::LOG_TRACE,false,false);
        } else {
            dhGlobal::logger("debugger",$debuggers,true,false);
        }
    }



    /**
     * dhGlobal:db() wrapper
     * @param mixed $config 
     * @param string $driver 
     * @return dhDB 
     * @throws Exception 
     */
    public static function db($config=null,$driver="Mysql") {
        return dhGlobal::db($config,$driver);
    }
    /**
     * dhGlobal::outLine() wrapper
     * @param mixed $args 
     * @return void 
     */
    public static function outLine(...$args) {
        return dhGlobal::outLine(...$args);
    }

    /**
     * dhutils Queue convinience static function - returns a $queue object.
     * @param mixed $max 
     * @param mixed $retriesOnError 
     * @param mixed $visualize 
     * @param int $workerErrorLimit 
     * @param mixed $workerBootstrap defaults to VtigerTools bootstrap script, false to disable
     * @return Queue 
     */
    public static function Queue($max = null, $retriesOnError = null, $visualize = null, $workerErrorLimit = 0,$workerBootstrap=null) {
        if(is_null($workerBootstrap)) {
            if(file_exists(__DIR__."/../bootstrap.php")) {
                $workerBootstrap = __DIR__."/../bootstrap.php";
            }
        } elseif($workerBootstrap === false) {
            $workerBootstrap = null;
        } 
        $queue = new Queue($max,$workerBootstrap,$retriesOnError,$visualize,$workerErrorLimit);
        $queue->setBootstrapAsCallable(false);
    }

    public static function trace(...$args) {
        dhGlobal::trace(...$args);
    }
    public static function info(...$args) {
        dhGlobal::info(...$args);
    }
    public static function debug(...$args) {
        dhGlobal::debug(...$args);
    }
    public static function warn(...$args) {
        dhGlobal::warn(...$args);
    }
    public static function error(...$args) {
        dhGlobal::error(...$args);
    }
}