<?php
namespace boru\vtigertools\structure;

class Block {
    private $blockLabel;

    /** @var \Vtiger_Block|false */
    private $instance=false;

    /** @var Module|false */
    private $module = false;

    /** @var bool */
    private $exists = false;

    private $create = true;

    public function __construct($blockLabel,$module=null,$create=true) {
        $this->blockLabel = $blockLabel;
        $this->create = $create;
        $this->module($module);
        if($this->create) {
            $this->create();
        }
    }
    public function create() {
        if($this->module instanceof Module && !$this->exists) {
            $this->instance->__create($this->getModuleInstance());
            $this->exists = true;
        }
        return $this;
    }
    public function getBlock() {
        return $this->instance;
    }
    public function exists() {
        return $this->exists;
    }
    public function getModule() {
        return $this->module;
    }
    public function getModuleInstance() {
        return $this->module->getModule();
    }

    public function module($module) {
        if(is_null($module)) {
            return $this;
        }
        if(is_object($module) && $module instanceof Module) {
            $this->module = $module;
        } else {
            $this->module = new Module($module);
        }
        if(($instance = $this->module->blockInstance($this->blockLabel)) !== false) {
            $this->instance = $instance;
            $this->exists = true;
        } else {
            $this->instance = new \Vtiger_Block();
            $this->exists = false;
            $this->instance->name = $this->blockLabel;
        }
        return $this;
    }
    public function addField(Field $field) {
        $field->getVTFieldInstance()->__create($this->getBlock());
        return $this;
    }
}