<?php
namespace boru\vtigertools\structure;

class Module {
    /** @var \Vtiger_Module */
    private $instance;

    public function __construct($module) {
        if(is_object($module)) {
            $this->instance = $module;
        } else {
            $this->instance = \Vtiger_Module::getInstance($module);
        }
        if(!$this->instance) {
            throw new \Exception("Module $module not found");
        }
    }
    public function getModule() {
        return $this->instance;
    }
    public function fieldInstance($fieldLabel) {
        if(is_null($this->instance) || $this->instance === false) {
            return false;
        }
        return \Vtiger_Field::getInstance($fieldLabel,$this->module);
    }
    public function blockInstance($blockLabel) {
        if(is_null($this->instance) || $this->instance === false) {
            return false;
        }
        return \Vtiger_Block::getInstance($blockLabel,$this->module);
    }

    public function inBlock($label) {
        return new Block($label,$this,true);
    }
    public function block($label) {
        return $this->inBlock($label);
    }
}