<?php
namespace boru\vtigertools;

/**
 * This class is intended for composer callbacks and should not reference anything that is not part of the composer autoload
 * @package boru\vtigertools
 */
class Setup {
    public static function postAutoloadDump($event) {
        $vendorDir = $event->getComposer()->getConfig()->get('vendor-dir');
        $setup = false;
        if(file_exists($vendorDir."/boru/vtigertools/bootstrap.php")) {
            copy($vendorDir."/boru/vtigertools/bootstrap.php",$vendorDir."/bootstrap.php");
            $setup = true;
        } elseif(file_exists($vendorDir."/../bootstrap.php")) {
            copy($vendorDir."/../bootstrap.php",$vendorDir."/bootstrap.php");
            $setup = true;
        }

        if($setup) {
            echo "******************************\n";
            echo "VtigerTools Bootstrap is ready\nAdd To any script/action in Vtiger to autoload:\n";
            echo "\trequire_once('vendor/bootstrap.php');\n";
            echo "******************************\n";
        }
    }
}