<?php
namespace boru\vtigertools\structure\fields;

use boru\vtigertools\structure\Field;

class NumberField extends Field {
    public function __construct($fieldName,$fieldLabel,$decimals=0,$options=[]) {
        parent::__construct($fieldName,$fieldLabel,$options);
        $this->uiType(7);
        if($decimals==0) {
            $this->typeofData("I~O");
            $this->columnType("INT(19)");
        } else {
            $this->typeOfData("NN~O");
            $this->columnType("DECIMAL(19,$decimals)");
        }
    }
}