<?php
namespace boru\cli\models;

class Arg extends Model {
    public function initData() {
        $this->set('string',null);
        $this->set("consumed",false);
    }
    public function __construct($input=null) {
        $this->initData();
        if($input instanceof Arg) {
            $this->setData($input->toArray());
            return;
        }
        if(is_array($input)) {
            $this->setData($input);
            return;
        }
        $this->string($input);
    }

    /**
     * @param string|null $value
     * @return string
     */
    public function string($value=null) {
        if($value === null) {
            return $this->get('string');
        }
        $this->set('string',$value);
    }

    /**
     * @param bool|null $value
     * @return bool
     */
    public function consumed($value=null) {
        if($value === null) {
            return $this->get('consumed',false) ? true : false;
        }
        $this->set('consumed',$value ? true : false);
    }

    /**
     * @param bool|null $value
     * @return bool
     */
    public function used($value=null) {
        return $this->consumed($value);
    }

    public function consume() {
        $this->consumed(true);
    }

    public function isLong($name) {
        if($this->string() === "--$name") {
            return true;
        }
        return substr($this->string(),0,strlen($name)+3) === '--'.$name."=";
    }
    public function isShort($short) {
        if(substr($this->string(),0,1) === '-' && substr($this->string(),0,2) !== '--' && strlen($this->string()) > 1) {
            return strpos($this->string(),$short) !== false;
        } else {
            return false;
        }
    }
    /**
     * 
     * @param Param $param 
     * @param mixed $nextArg 
     * @return void 
     */
    public function isParam($param,$nextArg=null) {
        if($this->isLong($param->name())) {
            if($param->needsValue()) {
                $value = $this->longValue($nextArg);
                if($value !== false) {
                    $this->consume();
                    return $value;
                }
                return false;
            }
            $this->consume();
            return true;
        }
        if($this->isShort($param->short())) {
            if($param->needsValue()) {
                $value = $this->shortValue($param,$nextArg);
                if($value !== false) {
                    $this->consume();
                    return $value;
                }
                return false;
            }
            $this->consume();
            return true;
        }
        return false;
    }
    private function longValue($nextArg=null) {
        $equals = strpos($this->string(),'=');
        if($equals !== false) {
            return substr($this->string(),$equals+1);
        }
        if($nextArg !== null) {
            $nextArg->consume();
            return $nextArg->string();
        }
        return false;
    }
    private function shortValue($param,$nextArg=null) {
        $pos = strpos($this->string(),$param->short());
        if($pos !== false && $pos+1 < strlen($this->string())) {
            return substr($this->string(),$pos+1);
        }
        if($nextArg !== null) {
            $nextArg->consume();
            return $nextArg->string();
        }
        return false;
    }
}