<?php
namespace boru\cli\models;

use boru\cli\CommandInterface;
use Exception;

class ClassCommand extends Command {

    /**
     * Expectes className to be a string that is the name of a class that extends CommandInterface
     * @param mixed $className 
     * @return void 
     * @throws Exception 
     */
    public function __construct($className) {    
        if(!class_exists($className)) {
            throw new Exception("ClassCommand: Class $className does not exist");
        }
        if(!is_subclass_of($className,CommandInterface::class)) {
            throw new Exception("ClassCommand: Class $className does not implement CommandInterface");
        }
        $command = [
            "type" => "command",
            "name" => $className::commandName(),
            "description" => $className::commandDescription(),
        ];
        $name = $className::commandName();
        $description = $className::commandDescription();
        parent::__construct($command,$className::commandParams(),function($command) use ($className) {
            call_user_func_array([$className,"CLI_successCallback"],[$command]);
        },function($command,$args) use ($className) {
            call_user_func_array([$className,"CLI_errorCallback"],[$command]);
        });
        //$this->class($class);
    }
}