<?php
namespace boru\cli\models;

use boru\cli\Printer;
use boru\cli\CLI;

class Commands extends Model {

    private $args;

    public function initData() {
        $this->iteratorElement("commands");
        $this->set('commands',[]);
        $this->set("type","commands");
        $this->set("callback",null);
        $this->set("errorCallback",null);
        $this->set("cli",null);
        $this->set("parent",null);
    }

    public function __construct($commands=[],$callback=null, $errorCallback=null) {
        $this->initData();
        if($commands instanceof Commands) {
            $this->setData($commands->toArray());
            return;
        } 
        if($commands !== null && $commands !== false) {
            $this->commands($commands);
        }
        if($callback) {
            $this->callback($callback);
        }
        if($errorCallback) {
            $this->errorCallback($errorCallback);
        }
    }

    /**
     * @param CLI|null $parent
     * @return CLI|null
     */
    public function cli($parent=null) {
        if($parent !== null) {
            $this->set('cli',$parent);
        }
        return $this->get('cli',null);
    }

    /**
     * @param Commands|null $parent
     * @return Commands|null
     */
    public function parent($parent=null) {
        if($parent !== null) {
            $this->set('parent',$parent);
        }
        return $this->get('parent',null);
    }

    /**
     * @param array|null $commands
     * @return Command[]|Commands
     */
    public function commands($commands=null) {
        if($commands === null) {
            return $this->get('commands');
        }
        if($commands === false) {
            $this->set('commands',[]);
            return $this;
        }
        foreach($commands as $command) {
            $this->add($command);
        }
        //$this->set('commands',$commands);
        return $this;
    }

    public function callback($callback=null) {
        if($callback === null) {
            return $this->get('callback');
        }
        $this->set('callback',$callback);
        return $this;
    }

    public function errorCallback($errorCallback=null) {
        if($errorCallback === null) {
            return $this->get('errorCallback');
        }
        $this->set('errorCallback',$errorCallback);
        return $this;
    }

    public function command($command) {
        
    }

    public function commandByName($name) {
        foreach($this->commands() as $command) {
            if($command->name() === $name) {
                return $command;
            }
        }
        return false;
    }

    public function add($command) {
        if(is_array($command)) {
            foreach($command as $p) {
                $this->add($p);
            }
            return $this;
        }
        if($command instanceof Commands) {
            foreach($command->commands() as $p) {
                $this->add($p);
            }
            return $this;
        }
        $commands = $this->commands();
        $commands[] = $command;
        if($this->cli() !== null) {
            $command->cli($this->cli());
        }
        $command->commands($this);
        $this->set('commands',$commands);
        return $this;
    }

    public function matchCommand($consumeArg=true,$args=null) {
        if($args === null) {
            $args = $this->args;
        }
        $continue = true;
        while($continue) {
            $checkArg = $args->next();
            if(empty($checkArg) || substr($checkArg->string(),0,1) !== "-") {
                $continue = false;
            }
        }
        //$checkArg = $args->next();
        $processCommand = false;
        if(!empty($checkArg)) {
            foreach($this->commands() as $command) {
                if($command->name() === $checkArg->string()) {
                    if($consumeArg) {
                        $checkArg->used(true);
                    }
                    $processCommand = $command;
                    break;
                }
            }
        }
        if(!$consumeArg) {
            $args->rewind();
        }
        return $processCommand;
    }
    public function parse($args=null,$results=[]) {
        if(!$args instanceof Args) {
            $args = new Args($args);
        }
        $this->args = $args;
        $processCommand = $this->matchCommand(true);
        if($processCommand !== false) {
            $commandResult = $processCommand->parse($args,$results);
            if(is_array($commandResult)) {
                //command had an error
                if($this->errorCallback() !== null) {
                    $result = $this->errorCallback()($processCommand);
                    if($result !== true) {
                        return $result;
                    }
                }
                $this->print();
                return false;
            }
            if($commandResult === true && $this->callback() !== null) {
                $result = $this->callback()($processCommand);
                if($result === true) {
                    return $result;
                }
            }
            return $processCommand;
        } else {
            if($this->errorCallback() !== null) {
                if(($callbackResult = $this->errorCallback()($this)) !== true) {
                    if($callbackResult !== true) {
                        return $callbackResult;
                    }
                }
            }
        }
        if($this->cli() !== null) {
            $this->cli()->print(null,["banner"=>true]);
        } else {
            $this->print();
        }

        return false;
    }

    /**
     * 
     * @param Printer|null $printer 
     * @return void 
     */
    public function print($printer=null) {
        $output = false;
        if($printer === null) {
            $printer = new Printer();
            $output = true;
        }
        $printer->addLine("Available Commands:");
        $table = $printer->table();
        foreach($this->commands() as $command) {
            $table->row("",$command->name(),"--",$command->description())->setWidth(0,1);
        }
        if($output) {
            $printer->print();
        }
    }
    
}