<?php
namespace boru\cli\params;

use boru\cli\models\Param;

class Flag extends Param {
    public function initData() {
        parent::initData();
        $this->set("type","flag");
    }

    public function __construct($input=null) {
        parent::__construct($input);
        $this->type('flag');
    }

    public function parseArg($arg,$nextArg=null) {
        if($this->value() !== null && $this->multiple() === false) {
            return false;
        }
        if(($value = $arg->isParam($this,null)) !== false) {
            $this->value($value);
            $this->consume();
            return true;
        }
        return false;
    }

    public static function parseOptsArray($opts=[]) {
        $opts["needsValue"] = false;
        $opts["type"] = "flag";
        return $opts;
    }

    public function syntax() {
        return $this->short();
    }
}