<?php
namespace boru\cli\params;

use boru\cli\Printer;

class Help extends Flag {

    public static function parseSyntaxString($syntaxString,$opts=[]) {
        if(!isset($opts["short"]) || empty($opts["short"])) {
            $opts["short"] = "h";
        }
        if(!isset($opts["name"]) || empty($opts["name"])) {
            $opts["name"] = "help";
        }
        $opts["description"] = "Show this help message";
        $opts["required"] = false;
        return $opts;
    }

    /**
     * Create a new Param instance
     *
     * - example: *b|book+|The playbook.yml file to execute
     * - example: <>|action|The action to perform
     * - legend: * required, + multiple
     *   
     * @param mixed $syntaxString 
     * @param array $config 
     * @return static 
     * @throws Exception 
     */
    public static function create($syntaxString=null,$config=[]) {
        if($syntaxString === null) {
            $syntaxString = "h|help|Show this help message";
        }
        $object = parent::create($syntaxString,$config);
        $object->callback(function($params) {
            return static::printHelp($params);
        });
        return $object;
    }

    public static function printHelp($param) {
        $printer = new Printer();
        if(($cli = $param->cli()) === null) {
            $printer->line("No CLI object found");
            $printer->print();
            return false;
        }
        if(($commands = $cli->commands()) === null) {
            $printer->line("No commands object found");
            $printer->print();
            return false;
        }
        $args = $cli->args();
        if(($command = $commands->matchCommand(false,$args)) === false) {
            $cli->print();
            return false;
        }

        $printOptions = [
            "banner"=>false,
            "syntax"=>false,
            "error"=>null,
            "commands"=>false,
        ];
        $printer->separator();

        $syntax = $command->syntax();
        $printer->line("Usage: ".$syntax);
        $printer->line();
        $command->params()->print($printer);

        $printer->line();
        $printOptions["printer"] = $printer;
        $cli->print(null,$printOptions);
        return false;
    }
}