<?php
namespace boru\cli\params;

use boru\cli\models\Param;

class Option extends Param {
    public function initData() {
        parent::initData();
        $this->set("type","option");
    }

    public function __construct($input=null) {
        parent::__construct($input);
        $this->type('option');
    }

    
    public function parseArg($arg,$nextArg=null) {
        if($this->value() !== null && $this->multiple() === false) {
            return false;
        }
        if(($value = $arg->isParam($this,$nextArg)) !== false) {
            $this->value($value);
            $this->consumed(true);
            return true;
        }
        return false;
    }

    public static function parseOptsArray($opts=[]) {
        $opts["needsValue"] = true;
        $opts["type"] = "option";
        return $opts;
    }

    public function syntax() {
        $valueString = "";
        if($this->needsValue()) {
            $valueString = "<".$this->name().">";
        }
        if($this->short() !== null) {
            return "-".$this->short().' '.$valueString;
        }
        return "-".$this->name().'='.$valueString;
    }
}