<?php
namespace boru\cli\params;

use boru\cli\models\Param;

class Positional extends Param {
    public function initData() {
        parent::initData();
        $this->set("type","positional");
    }

    public function __construct($input=null) {
        parent::__construct($input);
        $this->type('positional');
    }

    public function parseArg($arg,$nextArg=null) {
        if($this->value() !== null && $this->multiple() === false) {
            return false;
        }
        if($arg && !empty($arg->string())) {
            $this->value($arg->string());
            $this->consumed(true);
            return true;
        }
    }

    public static function parseOptsArray($opts=[]) {
        $opts["short"] = null;
        $opts["type"] = "positional";
        return $opts;
    }

    public function syntax() {
        if($this->needsValue()) {
            return "<".$this->name().">";
        }
        return "[".$this->name()."]";
    }
}