<?php
namespace boru\cli\traits;

use boru\cli\models\Command;
use boru\cli\params\Flag;
use boru\cli\params\Option;
use boru\cli\params\Positional;

trait CreateParams {
    public function flag($syntaxString,$config=[]) {
        $flag = Flag::create($syntaxString,$config);
        $this->add($flag);
        return $flag;
    }
    public function option($syntaxString,$config=[]) {
        $option = Option::create($syntaxString,$config);
        $this->add($option);
        return $option;
    }
    public function positional($syntaxString,$config=[]) {
        $option = Positional::create($syntaxString,$config);
        $this->add($option);
        return $option;
    }
    public function command($syntaxString,$params=[],$callback=null) {
        $command = Command::create($syntaxString,$params,$callback);
        $this->add($command);
        return $command;
    }
}