<?php
namespace boru\cli\commands;

use boru\cli\CommandInterface;
use boru\cli\params\Option;
use boru\cli\params\Positional;
use boru\cli\Printer;

class HelpCommand extends CommandInterface {

    public static function commandName() {
        return "help";
    }

    public static function commandDescription() {
        return "Prints a list of available commands";
    }

    public static function commandParams() {
        return [
            Positional::create("command|The command to get help for",["required"=>false])
        ];
    }

    public function onSuccess($result, $arg = null) {
        if(($commandName = $result->get("command",false)) === false) {
            $arr = $this->args()->unused();
            if(!empty($arr)) {
                $arg = array_shift($arr);
                $commandName = $arg->string();
            }
        }
        if($commandName === false) {
            $result->cli()->print();
            return false;
        } else {
            $printer = new Printer();
            if(!$result->cli()) {
                $printer->line("No CLI object found");
                $printer->print();
                return false;
            }
            if(!$result->cli()->commands()) {
                $printer->line("No commands object found");
                $printer->print();
                return false;
            }
            $cliObject = $result->cli();
            $commandsObject = $cliObject->commands();
            $commandObject = $commandsObject->commandByName($commandName);
            $printOptions = [
                "banner"=>true,
                "syntax"=>false,
                "error"=>null,
                "commands"=>false,
            ];
            $printer->separator();
            if($commandObject) {
                $syntax = $commandObject->syntax();
                $printer->line("Usage: ".$syntax);
                $printer->line();
                $commandObject->params()->print($printer);
                
                
            } else {
                $printer->line("Command not found: ".$commandName);
                $printOptions["sytnax"] = true;
                $printOptions["commands"] = true;
                
            }
            $printer->line();
            $printOptions["printer"] = $printer;
            $cliObject->print(null,$printOptions);
            //$printer->print();
        }
        
    }

}