<?php
namespace boru\cli\models;

class Args extends Model {
    public function initData() {
        $this->set('args',[]);
        $this->set("originalArgs",[]);
        $this->set("cursor",0);
        $this->set("separator"," ");
        $this->iteratorElement("args");
        $this->set("script",null);
    }

    public function __construct($args=[],$options=["separator"=>" "]) {
        $this->initData();
        if($args instanceof Args) {
            $this->setData($args->toArray());
        } elseif($args !== null && $args !== false) {
            $this->args($args);
        }
        if(isset($options['separator'])) {
            $this->separator($options['separator']);
        }
    }

    public function script($script=null) {
        if($script === null) {
            return $this->get('script');
        }
        $this->set('script',$script);
        return $this;
    }

    public function unused() {
        return array_filter($this->args(),function($arg) {
            return !$arg->used();
        });
    }
    public function used() {
        return array_filter($this->args(),function($arg) {
            return $arg->used();
        });
    }

    public function separator($separator=null) {
        if($separator === null) {
            return $this->get('separator');
        }
        $this->set('separator',$separator);
        return $this;
    }

    public function cursor($cursor=null) {
        if($cursor === null) {
            return $this->get('cursor');
        }
        if($cursor === false || $cursor < 0) {
            $this->set('cursor',0);
            return;
        }
        $this->set('cursor',$cursor);
        return $this;
    }
    public function originalArgs($originalArgs=null) {
        if($originalArgs === null) {
            return $this->get('originalArgs');
        }
        if($originalArgs === false) {
            $this->set('originalArgs',[]);
            return $this;
        }
        $this->set('originalArgs',$originalArgs);
        return $this;
    }
    public function args($args=null) {
        if($args === null) {
            return $this->get('args');
        }
        if($args === false) {
            $this->set('args',[]);
            $this->set('originalArgs',[]);
            return;
        }
        if(!is_array($args)) {
            $args = explode($this->separator(),$args);
        }
        if(!is_array($args)) {
            throw new \Exception("Args must be an array, or a string separated an option separator (default is space)");
        }
        if(empty($args)) {
            global $argv;
            if(is_array($argv)) {
                $args = $argv;
                $this->set("script",array_shift($args));
            }
        }
        $this->set("args",[]);
        foreach($args as $arg) {
            if(is_object($arg)) {
                    $this->appendArray("args",$arg);
            } else {
                $this->appendArray("args",new Arg($arg));
            };
        }
        $this->set("originalArgs",$this->args());
    }

    public function rewind() {
        $this->args($this->originalArgs());
    }
    public function hasNext() {
        return isset($this->args()[$this->cursor()]);
    }
    public function shift($both=false) {
        $shift = $this->shiftArray("args");
        if($shift !== null) {
            if($both) {
                $this->shiftArray("originalArgs");
            }
            $this->cursor($this->cursor() - 1);
            return $shift;
        }
        return false;
    }
    public function next($updateCursor=true) {
        if(isset($this->args()[$this->cursor()])) {
            $next = $this->args()[$this->cursor()];
            if($updateCursor) {
                $this->cursor($this->cursor() + 1);
                if($next->used()) {
                    return $this->next();
                }
            }
            return $next;
        }
        return null;
    }

}