<?php
namespace boru\cli\printer;

class TableLine extends Line {
    /** @var Table */
    private $table;
    public function __construct($table,$printer) {
        $this->table($table);
        $this->printer($printer);
    }
    public function table($table=null) {
        if($table === null) {
            return $this->table;
        }
        $this->table = $table;
        return $this;
    }
    public function __toString() {
        return implode("\n",$this->table->display(true));
    }
    public function preParse() {
        $replace = [
            "{INDENT}"      => $this->makeIndent(),
        ];
        foreach($replace as $key => $value) {
            $this->table->replace($key,$value);
        }
    }
    public function parse($force=false) {
        $length = $this->table->displayLength();
        $this->printer()->registerLength($length);
        return $this;
    }
    public function postParse() {
        return $this;
    }
}