<?php
namespace boru\cli\traits;

use boru\cli\CLI;
use boru\cli\models\Command;
use boru\cli\models\CommandGroup;
use boru\cli\params\Flag;
use boru\cli\params\Option;
use boru\cli\params\Positional;

trait CreateParams {
    public function flag($syntaxString,$config=[]) {
        $flag = Flag::create($syntaxString,$config);
        $this->add($flag);
        return $flag;
    }
    public function option($syntaxString,$config=[]) {
        $option = Option::create($syntaxString,$config);
        $this->add($option);
        return $option;
    }
    public function positional($syntaxString,$config=[]) {
        $option = Positional::create($syntaxString,$config);
        $this->add($option);
        return $option;
    }
    public function command($syntaxString,$params=[],$callback=null) {
        $isGroup = false;
        $commands = [];
        foreach($params as $i=>$param) {
            if($param instanceof Command) {
                $isGroup = true;
                $commands[] = $param;
                unset($params[$i]);
            }
        }
        if($isGroup) {
            $command = CommandGroup::create($syntaxString,$params,$callback);
            if($this->cli()) {
                $command->cli($this->cli());
            } elseif($this instanceof CLI) {
                $command->cli($this);
            }
            $this->add($command);
            foreach($commands as $c) {
                $command->add($c);
            }
            return $command;
        }
        $command = Command::create($syntaxString,$params,$callback);
        $this->add($command);
        if($this->cli()) {
            $command->cli($this->cli());
        }
        return $command;
    }
    public function commandGroup($syntaxString,$params=[],$callback=null) {
        $command = CommandGroup::create($syntaxString,$params,$callback);
        $command->cli($this);
        $this->add($command);
        return $command;
    }
}