<?php
namespace boru\cli\models;

use boru\cli\CLI;

class CommandGroup extends CLI {
    public function id() {
        return "commandGroup";
    }
    public function __construct($syntaxOrArray="", $params=null, $callback=null) {
        parent::__construct($syntaxOrArray,$params,$callback,true);
        $this->type("commandGroup");
        //$this->commands(false);
    }

    /**
     * Parse the arguments
     * @param array $args
     * @return true|array
     */
    public function parse($args=null,$prev=null) {
        if($this->cli()) {
            foreach($this->cli()->params() as $param) {
                foreach($this->params() as $p) {
                    if($param->name() === $p->name()) {
                        $p->value($param->value());
                    }
                }
            }
        }
        parent::parse($args,$prev);
    }

    public static function create($syntaxOrArray="", $params=null, $callback=null) {
        return new self($syntaxOrArray, $params, $callback);
    }
}