<?php
namespace boru\cli\params;

use boru\cli\CLI;
use boru\cli\models\Param;

class Positional extends Param {
    private $reachedEnd = false;
    public function initData() {
        parent::initData();
        $this->set("type","positional");
    }

    public function __construct($input=null) {
        parent::__construct($input);
        $this->type('positional');
    }

    public function longDisplay() {
        return $this->name();
    }

    public function parseArg($arg,$nextArg=null) {
        if($this->finished()) {
            return false;
        }
        if($this->value() !== null && $this->multiple() === false) {
            return false;
        }
        if($this->finished()) {
            return false;
        }
        if($arg && !empty($arg->string()) && ($value = $arg->isParam($this,null)) !== false) {
            $this->value($value);
            $this->consume();
            return true;
        }
        return false;
        /*if($arg && !empty($arg->string())) {
            $this->debug("Setting value to ".$arg->string());
            $arg->consume();
            $this->value($arg->string());
            $this->consumed(true);
            return true;
        }*/
    }

    public static function parseOptsArray($opts=[]) {
        $opts["short"] = null;
        $opts["type"] = "positional";
        return $opts;
    }

    public function syntax() {
        if($this->needsValue()) {
            return "<".$this->name().">";
        }
        return "[".$this->name()."]";
    }

    protected function debug(...$args) {
        CLI::debugCLIformatted("Param/Positional",$this->name(),...$args);
    }
}