<?php
namespace boru\cli\printer;

class Table {
    private $rows = [];
    private $columnProperties = [];

    private $columnPadding = 1;
    private $columnPad = " ";
    private $columnSeparator = "";

    public function __construct(...$rows) {
        $this->rows = $rows;
    }

    public function replace($search,$replace) {
        foreach($this->rows as $row) {
            $row->replace($search,$replace);
        }
        return $this;
    }

    public function displayLength() {
        $length = 0;
        $display = $this->display(true);
        foreach($display as $line) {
            $lineLength = strlen($line);
            if($lineLength > $length) {
                $length = $lineLength;
            }
        }
        return $length;
    }

    /**
     * Add a row to the table
     * @param mixed $row 
     * @return $this
     */
    public function add($row) {
        if($row instanceof Row) {
            $row->table($this);
            $this->rows[] = $row;
            return $this;
        }
        if(is_array($row)) {
            $row = new Row(...$row);            
        } else {
            $row = new Row($row);
        }
        $row->table($this);
        $this->rows[] = $row;
        return $this;
    }
    /**
     * Get or set the rows of the table
     * @param array|null $rows 
     * @return Row[]|Table 
     */
    public function rows($rows=null) {
        if($rows === null) {
            return $this->rows;
        }
        $this->rows = $rows;
        return $this;
    }
    /**
     * Add a row to the table
     * @param mixed ...$cells 
     * @return Row 
     */
    public function row(...$cells) {
        if(count($cells) === 1 && is_array($cells[0])) {
            $cells = $cells[0];
        }
        if(count($cells) === 1 && $cells[0] instanceof Row) {
            $row = $cells[0];
        } else {
            $row = new Row(...$cells);
        }
        $row->table($this);
        $this->rows[] = $row;
        return $row;
    }

    /**
     * Get or set the padding for the columns
     * @param int|null $padding 
     * @return int|Table 
     */
    public function columnProperties($index,$properties) {
        $this->columnProperties[$index] = $properties;
        return $this;
    }
    /**
     * Get or set the padding for the columns
     * @param int|null $padding 
     * @return int|Table 
     */
    public function padding($padding=null) {
        if($padding === null) {
            return $this->columnPadding;
        }
        $this->columnPadding = $padding;
        return $this;
    }
    /**
     * Get or set the padding for the columns
     * @param int|null $padding 
     * @return int|Table 
     */
    public function pad($pad=null) {
        if($pad === null) {
            return $this->columnPad;
        }
        $this->columnPad = $pad;
        return $this;
    }
    /**
     * Get or set the padding for the columns
     * @param int|null $padding 
     * @return int|Table 
     */
    public function separator($separator=null) {
        if($separator === null) {
            return $this->columnSeparator;
        }
        $this->columnSeparator = $separator;
        return $this;
    }



    public function columnWidth($index,$width=null) {
        if($width === null) {
            if(!isset($this->columnProperties[$index]) || !isset($this->columnProperties[$index]["width"])) {
                return 0;
            }
            return $this->columnProperties[$index]["width"];
        }
        if(!isset($this->columnProperties[$index])) {
            $this->columnProperties[$index] = [];
        }
        $this->columnProperties[$index]["width"] = $width;
        return $this;
    }

    private function buildWidths() {
        foreach($this->rows as $row) {
            $lengths = $row->lengths();
            foreach($lengths as $index=>$length) {
                if(!isset($this->columnProperties[$index])) {
                    $this->columnProperties[$index] = [];
                }
                if(!isset($this->columnProperties[$index]["width"])) {
                    $this->columnProperties[$index]["width"] = 0;
                }
                if($length > $this->columnProperties[$index]["width"]) {
                    $this->columnProperties[$index]["width"] = $length;
                }
            }
        }
    }
    public function display($asArray=false) {
        $this->buildWidths();
        $lines = [];
        foreach($this->rows as $row) {
            $row->padding($this->padding());
            $row->pad($this->pad());
            $row->separator($this->separator());
            $lines[] = $row->display();
        }
        if($asArray) {
            return $lines;
        }
        foreach($lines as $line) {
            echo $line.PHP_EOL;
        }
    }
}