<?php
namespace boru\cli;

use boru\cli\models\Command;
use boru\cli\models\Args;
use boru\cli\models\Params;

abstract class CommandInterface {

    /** @return string */
    abstract public static function commandName();

    /** @return string */
    abstract public static function commandDescription();

    /** @return Param[]|Params|array */
    abstract public static function commandParams();

    /**
     * This function is called when the command is successful
     * @param Command $command 
     * @return bool 
     */
    public static function CLI_successCallback($command) {
        $object = new static(true,$command);
        return call_user_func_array([$object,"onSuccess"],[$command]);
    }

    /**
     * This function is called when the command is not successful
     * @param Command $command 
     * @return bool 
     */
    public static function CLI_errorCallback($command) {
        $object = new static(false,$command);
        return call_user_func_array([$object,"onError"],[$command]);
    }


    /** var bool */
    private $commandSuccess = false;
    /** @var Command */
    private $commandObject = null;
    /** @var Args */
    private $argsObject = null;

    public function __construct($scucess,$command) {
        $this->commandSuccess = $scucess;
        $this->commandObject = $command;
        if($command) {
            $this->argsObject = $command->args();
        }
    }

    /**
     * @return Command
     */
    public function command() {
        return $this->commandObject;
    }
    /**
     * @return Args
     */
    public function args() {
        return $this->argsObject;
    }
    /**
     * @return bool
     */
    public function success() {
        return $this->commandSuccess;
    }
    /**
     * Returns the value of the key from the result/command object
     * @param string $key
     * @param mixed $default
     * @return bool
     */
    public function get($key,$default=null) {
        if($this->argsObject) {
            return $this->argsObject->get($key,$default);
        }
        return $default;
    }

    /**
     * Sets the value of the key in the result/command object
     * @param string $key
     * @param mixed $value
     * @return CommandInterface
     */
    public function set($key,$value) {
        if($this->commandObject) {
            return $this->commandObject->set($key,$value);
        }
        return $this;
    }

    /**
     * This is the callback function that is called when the command is successful
     * @param Command $command 
     * @param Args|null $args 
     * @return mixed|true if true, the CLI will continue to run, otherwise the CLI will stop
     */
    abstract public function onSuccess($command,$arg=null);

    /**
     * This is the callback function that is called when the command is not successful
     * @param Command $command 
     * @param Args|null $args 
     * @return mixed|true if true, the CLI will continue to run, otherwise the CLI will stop
     */
    public function onError($command,$args=null) {
        if($command->cli()) {
            $command->cli()->print();
        }
        return true;
    }
}