<?php
namespace boru\cli\models;

use boru\dhutils\dhGlobal;
use boru\dot\Dot;
use Traversable;

abstract class Model implements \JsonSerializable, \ArrayAccess, \IteratorAggregate {
    protected $modelData = [];

    protected $iteratorElement;

    abstract public function initData();
    
    public function iteratorElement($element=null) {
        if($element === null) {
            return $this->iteratorElement;
        }
        $this->iteratorElement = $element;
        return $this;
    }
    public function shiftArray($name) {
        $current = $this->get($name);
        if(is_array($current)) {
            return array_shift($current);
        }
        return null;
    }
    public function appendArray($name,$value) {
        $current = $this->get($name);
        if(is_array($current)) {
            $current[] = $value;
            $this->set($name,$current);
        } else {
            throw new \Exception('Cannot append to variable of type ' . gettype($current));
        }
    }

    public function get($name=null,$default=null) {
        if($name === null) {
            return $this->modelData;
        }
        return Dot::get($this->modelData,$name,$default);
    }
    public function set($name,$value) {
        if(strpos($name,".") !== false) {
            Dot::set($this->modelData,$name,$value);
        }
        else {
            $this->modelData[$name] = $value;
        }
    }
    public function exists($column=null) {
        if(is_null($column)) {
            return !empty($this->modelData);
        }
        return !is_null(Dot::get($this->modelData,$column,null));
    }
    public function remove($column) {
        return Dot::delete($this->modelData,$column);
    }

    public function setData($data=[]) {
        if(!is_array($data) && !is_object($data)) {
            $data = json_decode($data);
        }
        if(is_object($data) && method_exists($data, 'toArray')) {
            $data = $data->toArray();
        }
        if(!is_array($data)) {
            throw new \Exception('Data must be an array or object in ' . get_class($this). '::setData() line ' . __LINE__. ' in ' . __FILE__);
        }
        foreach($data as $key=>$value) {
            if(method_exists($this,$key)) {
                $this->$key($value);
                unset($data[$key]);
            } elseif(strpos($key,"_") !== false) {
                $parts = explode("_",$key);
                $start = array_shift($parts);
                $parts = array_map(function($part) {
                    return ucfirst($part);
                },$parts);
                $key = $start . implode("",$parts);
                if(method_exists($this,$key)) {
                    $this->$key($value);
                    unset($data[$key]);
                }
            }
        }
        if(count($data) > 0) {
            $this->modelData = array_merge($this->modelData,$data);
        }
    }
    public function toArray() {
        return $this->modelData;
    }
    public function __toString() {
        return json_encode($this->toArray());
    }
    public function jsonSerialize() {
        return $this->toArray();
    }
    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetExists($offset) {
        return $this->exists($offset);
    }

    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetGet($offset) {
        return $this->get($offset);
    }

    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetSet($offset , $value) {
        $this->set($offset,$value);
    }

    /**
     * Ignore intelephense error, php 5.6 :(
     */
    public function offsetUnset($offset) {
        $this->remove($offset);
    }

    public function getIterator() {
        if($this->iteratorElement !== null) {
            return new \ArrayIterator($this->modelData[$this->iteratorElement]);
        }
        return new \ArrayIterator($this->modelData);
    }
}